/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http;

import com.basho.riak.client.http.RiakBucketInfo;
import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.request.MapReduceBuilder;
import com.basho.riak.client.http.request.RequestMeta;
import com.basho.riak.client.http.request.RiakWalkSpec;
import com.basho.riak.client.http.response.BucketResponse;
import com.basho.riak.client.http.response.FetchResponse;
import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.IndexResponse;
import com.basho.riak.client.http.response.ListBucketsResponse;
import com.basho.riak.client.http.response.MapReduceResponse;
import com.basho.riak.client.http.response.RiakExceptionHandler;
import com.basho.riak.client.http.response.RiakIORuntimeException;
import com.basho.riak.client.http.response.RiakResponseRuntimeException;
import com.basho.riak.client.http.response.StoreResponse;
import com.basho.riak.client.http.response.StreamHandler;
import com.basho.riak.client.http.response.WalkResponse;
import com.basho.riak.client.http.util.ClientHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakClient {
    private ClientHelper helper;

    public RiakConfig getConfig() {
        return this.helper.getConfig();
    }

    public RiakClient(RiakConfig config) {
        this(config, null);
    }

    public RiakClient(RiakConfig config, String clientId) {
        this.helper = new ClientHelper(config, clientId);
    }

    public RiakClient(String url) {
        this(new RiakConfig(url), null);
    }

    public RiakClient(String url, String clientId) {
        this(new RiakConfig(url), clientId);
    }

    RiakClient(ClientHelper helper) {
        this.helper = helper;
    }

    public HttpResponse setBucketSchema(String bucket, RiakBucketInfo bucketInfo, RequestMeta meta) {
        JSONObject schema = null;
        try {
            schema = new JSONObject().put("props", bucketInfo.getSchema());
        }
        catch (JSONException unreached) {
            throw new IllegalStateException("wrapping valid json should be valid", unreached);
        }
        return this.helper.setBucketSchema(bucket, schema, meta);
    }

    public HttpResponse setBucketSchema(String bucket, RiakBucketInfo bucketInfo) {
        return this.setBucketSchema(bucket, bucketInfo, null);
    }

    public BucketResponse getBucketSchema(String bucket, RequestMeta meta) {
        HttpResponse r = this.helper.getBucketSchema(bucket, meta);
        try {
            return this.getBucketResponse(r);
        }
        catch (JSONException e) {
            try {
                return new BucketResponse(this.helper.toss(new RiakResponseRuntimeException(r, (Throwable)e)));
            }
            catch (Exception e1) {
                throw new IllegalStateException("helper.toss() returns a unsuccessful result, so BucketResponse shouldn't try to parse it or throw");
            }
        }
        catch (IOException e) {
            try {
                return new BucketResponse(this.helper.toss(new RiakIORuntimeException(e)));
            }
            catch (Exception e1) {
                throw new IllegalStateException("helper.toss() returns a unsuccessful result, so BucketResponse shouldn't try to read it or throw");
            }
        }
    }

    public BucketResponse getBucketSchema(String bucket) {
        return this.getBucketSchema(bucket, null);
    }

    public BucketResponse listBucket(String bucket, RequestMeta meta) {
        return this.listBucket(bucket, meta, false);
    }

    public BucketResponse listBucket(String bucket) {
        return this.listBucket(bucket, null);
    }

    public BucketResponse streamBucket(String bucket, RequestMeta meta) {
        return this.listBucket(bucket, meta, true);
    }

    public BucketResponse streamBucket(String bucket) {
        return this.streamBucket(bucket, null);
    }

    BucketResponse listBucket(String bucket, RequestMeta meta, boolean streamResponse) {
        HttpResponse r = this.helper.listBucket(bucket, meta, streamResponse);
        try {
            return this.getBucketResponse(r);
        }
        catch (JSONException e) {
            try {
                return new BucketResponse(this.helper.toss(new RiakResponseRuntimeException(r, (Throwable)e)));
            }
            catch (Exception e1) {
                throw new IllegalStateException("helper.toss() returns a unsuccessful result, so BucketResponse shouldn't try to parse it or throw");
            }
        }
        catch (IOException e) {
            try {
                return new BucketResponse(this.helper.toss(new RiakIORuntimeException(e)));
            }
            catch (Exception e1) {
                throw new IllegalStateException("helper.toss() returns a unsuccessful result, so BucketResponse shouldn't try to read it or throw");
            }
        }
    }

    public StoreResponse store(RiakObject object, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("returnbody") == null) {
            meta.setQueryParam("returnbody", "true");
        }
        this.setAcceptHeader(meta);
        HttpResponse r = this.helper.store(object, meta);
        return new StoreResponse(new FetchResponse(r, this));
    }

    private void setAcceptHeader(RequestMeta meta) {
        String accept = meta.getHeader("accept");
        if (accept == null) {
            meta.setHeader("accept", "*/*, multipart/mixed");
        } else {
            meta.setHeader("accept", accept + ", " + "multipart/mixed");
        }
    }

    public StoreResponse store(RiakObject object) {
        return this.store(object, null);
    }

    public FetchResponse fetchMeta(String bucket, String key, RequestMeta meta) {
        try {
            if (meta == null) {
                meta = new RequestMeta();
            }
            this.setAcceptHeader(meta);
            HttpResponse resp = this.helper.fetchMeta(bucket, key, meta);
            if (resp.getStatusCode() != 300) {
                return this.getFetchResponse(resp);
            }
            return this.fetch(bucket, key, meta);
        }
        catch (RiakResponseRuntimeException e) {
            return new FetchResponse(this.helper.toss(e), this);
        }
    }

    public FetchResponse fetchMeta(String bucket, String key) {
        return this.fetchMeta(bucket, key, null);
    }

    public FetchResponse fetch(String bucket, String key, RequestMeta meta) {
        return this.fetch(bucket, key, meta, false);
    }

    public FetchResponse fetch(String bucket, String key) {
        return this.fetch(bucket, key, null, false);
    }

    public FetchResponse stream(String bucket, String key, RequestMeta meta) {
        return this.fetch(bucket, key, meta, true);
    }

    public FetchResponse stream(String bucket, String key) {
        return this.fetch(bucket, key, null, true);
    }

    FetchResponse fetch(String bucket, String key, RequestMeta meta, boolean streamResponse) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        this.setAcceptHeader(meta);
        HttpResponse r = this.helper.fetch(bucket, key, meta, streamResponse);
        try {
            return this.getFetchResponse(r);
        }
        catch (RiakResponseRuntimeException e) {
            return new FetchResponse(this.helper.toss(e), this);
        }
    }

    public boolean stream(String bucket, String key, StreamHandler handler, RequestMeta meta) throws IOException {
        return this.helper.stream(bucket, key, handler, meta);
    }

    public HttpResponse delete(String bucket, String key, RequestMeta meta) {
        return this.helper.delete(bucket, key, meta);
    }

    public HttpResponse delete(String bucket, String key) {
        return this.delete(bucket, key, null);
    }

    public WalkResponse walk(String bucket, String key, String walkSpec, RequestMeta meta) {
        HttpResponse r = this.helper.walk(bucket, key, walkSpec, meta);
        try {
            return this.getWalkResponse(r);
        }
        catch (RiakResponseRuntimeException e) {
            return new WalkResponse(this.helper.toss(e), this);
        }
    }

    public WalkResponse walk(String bucket, String key, String walkSpec) {
        return this.walk(bucket, key, walkSpec, null);
    }

    public WalkResponse walk(String bucket, String key, RiakWalkSpec walkSpec) {
        return this.walk(bucket, key, walkSpec.toString(), null);
    }

    public MapReduceResponse mapReduce(String job, RequestMeta meta) {
        HttpResponse r = this.helper.mapReduce(job, meta);
        try {
            return this.getMapReduceResponse(r);
        }
        catch (JSONException e) {
            this.helper.toss(new RiakResponseRuntimeException(r, (Throwable)e));
            return null;
        }
    }

    public MapReduceResponse mapReduce(String job) {
        return this.mapReduce(job, null);
    }

    public MapReduceBuilder mapReduceOverBucket(String bucket) {
        return new MapReduceBuilder(this).setBucket(bucket);
    }

    public MapReduceBuilder mapReduceOverObjects(Map<String, Set<String>> objects) {
        return new MapReduceBuilder(this).setRiakObjects(objects);
    }

    public MapReduceBuilder mapReduceOverSearch(String bucket, String search) {
        return new MapReduceBuilder(this).setBucket(bucket).setSearch(search);
    }

    public RiakExceptionHandler getExceptionHandler() {
        return this.helper.getExceptionHandler();
    }

    public void setExceptionHandler(RiakExceptionHandler exceptionHandler) {
        this.helper.setExceptionHandler(exceptionHandler);
    }

    public HttpClient getHttpClient() {
        return this.helper.getHttpClient();
    }

    public byte[] getClientId() {
        return this.helper.getClientId();
    }

    public void setClientId(String clientId) {
        this.helper.setClientId(clientId);
    }

    BucketResponse getBucketResponse(HttpResponse r) throws JSONException, IOException {
        return new BucketResponse(r);
    }

    FetchResponse getFetchResponse(HttpResponse r) throws RiakResponseRuntimeException {
        return new FetchResponse(r, this);
    }

    WalkResponse getWalkResponse(HttpResponse r) throws RiakResponseRuntimeException {
        return new WalkResponse(r, this);
    }

    MapReduceResponse getMapReduceResponse(HttpResponse r) throws JSONException {
        return new MapReduceResponse(r);
    }

    public ListBucketsResponse listBuckets() {
        HttpResponse r = this.helper.listBuckets();
        try {
            return new ListBucketsResponse(r);
        }
        catch (JSONException e) {
            try {
                return new ListBucketsResponse(this.helper.toss(new RiakResponseRuntimeException(r, (Throwable)e)));
            }
            catch (Exception e1) {
                throw new IllegalStateException("helper.toss() returns a unsuccessful result, so BucketResponse shouldn't try to parse it or throw");
            }
        }
        catch (IOException e) {
            try {
                return new ListBucketsResponse(this.helper.toss(new RiakIORuntimeException(e)));
            }
            catch (Exception e1) {
                throw new IllegalStateException("helper.toss() returns a unsuccessful result, so BucketResponse shouldn't try to read it or throw");
            }
        }
    }

    public HttpResponse ping() {
        return this.helper.ping();
    }

    public HttpResponse stats() {
        return this.helper.stats();
    }

    public IndexResponse index(String bucket, String indexName, String value) {
        return this.makeIndexResponse(this.helper.fetchIndex(bucket, indexName, new String[]{value}));
    }

    public IndexResponse index(String bucket, String indexName, int value) {
        return this.makeIndexResponse(this.helper.fetchIndex(bucket, indexName, new int[]{value}));
    }

    public IndexResponse index(String bucket, String indexName, String start, String end) {
        return this.makeIndexResponse(this.helper.fetchIndex(bucket, indexName, new String[]{start, end}));
    }

    public IndexResponse index(String bucket, String indexName, int start, int end) {
        return this.makeIndexResponse(this.helper.fetchIndex(bucket, indexName, new int[]{start, end}));
    }

    private IndexResponse makeIndexResponse(HttpResponse r) {
        try {
            return new IndexResponse(r);
        }
        catch (JSONException e) {
            try {
                return new IndexResponse(this.helper.toss(new RiakResponseRuntimeException(r, (Throwable)e)));
            }
            catch (Exception e1) {
                throw new IllegalStateException("helper.toss() returns a unsuccessful result, so BucketResponse shouldn't try to parse it or throw");
            }
        }
    }

    public void shutdown() {
    }
}

