/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query.indexes;

import com.basho.riak.client.RiakException;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.query.indexes.BinIndex;
import com.basho.riak.client.query.indexes.IntIndex;
import com.basho.riak.client.query.indexes.RiakIndex;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.query.indexes.BinRangeQuery;
import com.basho.riak.client.raw.query.indexes.BinValueQuery;
import com.basho.riak.client.raw.query.indexes.IndexQuery;
import com.basho.riak.client.raw.query.indexes.IntRangeQuery;
import com.basho.riak.client.raw.query.indexes.IntValueQuery;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchIndex<T>
implements RiakOperation<List<String>> {
    private final RawClient client;
    protected final RiakIndex<T> index;
    private final String bucket;
    protected T value;
    protected T from;
    protected T to;
    private Retrier retrier;

    public FetchIndex(RawClient client, String bucket, RiakIndex<T> index, Retrier retrier) {
        this.client = client;
        this.bucket = bucket;
        this.index = index;
        this.retrier = retrier;
    }

    @Override
    public List<String> execute() throws RiakException {
        if (this.value == null && (this.to == null || this.from == null)) {
            throw new IllegalStateException("Must set either value or range");
        }
        final IndexQuery indexQuery = this.makeIndexQuery();
        List<String> keys = this.retrier.attempt(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return FetchIndex.this.client.fetchIndex(indexQuery);
            }
        });
        return keys;
    }

    private IndexQuery makeIndexQuery() {
        if (this.isRange()) {
            return this.makeRangeQuery();
        }
        return this.makeValueQuery();
    }

    private boolean isRange() {
        return this.to != null && this.from != null;
    }

    private IndexQuery makeValueQuery() {
        if (this.value.getClass().equals(String.class)) {
            return new BinValueQuery((BinIndex)this.index, this.bucket, (String)this.value);
        }
        if (this.value.getClass().equals(Integer.class)) {
            return new IntValueQuery((IntIndex)this.index, this.bucket, (Integer)this.value);
        }
        return null;
    }

    private IndexQuery makeRangeQuery() {
        if (this.to.getClass().equals(String.class)) {
            return new BinRangeQuery((BinIndex)this.index, this.bucket, (String)this.from, (String)this.to);
        }
        if (this.to.getClass().equals(Integer.class)) {
            return new IntRangeQuery((IntIndex)this.index, this.bucket, (Integer)this.from, (Integer)this.to);
        }
        throw new RuntimeException("Unkown range query type " + this.to.getClass());
    }

    public FetchIndex<T> withValue(T value) {
        this.value = value;
        return this;
    }

    public FetchIndex<T> from(T from) {
        this.from = from;
        return this;
    }

    public FetchIndex<T> to(T to) {
        this.to = to;
        return this;
    }
}

