/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.client.raw.ClusterClient;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.Transport;
import com.basho.riak.client.raw.config.ClusterConfig;
import com.basho.riak.client.raw.pbc.PBClientAdapter;
import com.basho.riak.client.raw.pbc.PBClientConfig;
import com.basho.riak.client.raw.pbc.PoolSemaphore;
import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakConnectionPool;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBClusterClient
extends ClusterClient<PBClientConfig> {
    public PBClusterClient(ClusterConfig<PBClientConfig> clusterConfig) throws IOException {
        super(clusterConfig);
    }

    @Override
    protected RawClient[] fromConfig(ClusterConfig<PBClientConfig> clusterConfig) throws IOException {
        ArrayList<PBClientAdapter> clients = new ArrayList<PBClientAdapter>();
        int totalMaxConnections = clusterConfig.getTotalMaximumConnections();
        Semaphore clusterSemaphore = null;
        if (totalMaxConnections > 0) {
            clusterSemaphore = RiakConnectionPool.getSemaphore(totalMaxConnections);
        }
        for (PBClientConfig node : clusterConfig.getClients()) {
            RiakConnectionPool hostPool = this.makePool(clusterSemaphore, node);
            hostPool.start();
            clients.add(new PBClientAdapter(new RiakClient(hostPool)));
        }
        return clients.toArray(new RawClient[clients.size()]);
    }

    private RiakConnectionPool makePool(Semaphore clusterSemaphore, PBClientConfig node) throws IOException {
        RiakConnectionPool pool = null;
        pool = clusterSemaphore == null ? new RiakConnectionPool(node.getInitialPoolSize(), node.getPoolSize(), InetAddress.getByName(node.getHost()), node.getPort(), node.getConnectionWaitTimeoutMillis(), node.getSocketBufferSizeKb(), node.getIdleConnectionTTLMillis()) : new RiakConnectionPool(node.getInitialPoolSize(), new PoolSemaphore(clusterSemaphore, node.getPoolSize()), InetAddress.getByName(node.getHost()), node.getPort(), node.getConnectionWaitTimeoutMillis(), node.getSocketBufferSizeKb(), node.getIdleConnectionTTLMillis());
        return pool;
    }

    @Override
    public Transport getTransport() {
        return Transport.PB;
    }
}

