/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.RPB;
import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakConnection;
import com.basho.riak.pbc.RiakStreamClient;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeySource
extends RiakStreamClient<ByteString> {
    private RPB.RpbListKeysResp r;
    private int i;

    public KeySource(RiakClient client, RiakConnection conn) throws IOException {
        super(client, conn);
        this.get_next_response();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.isClosed()) {
            return false;
        }
        if (this.r_is_exhausted()) {
            this.get_next_response();
        }
        return !this.isClosed();
    }

    private boolean r_is_exhausted() {
        return this.i == this.r.getKeysCount();
    }

    @Override
    public ByteString next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.r.getKeys(this.i++);
    }

    private void get_next_response() throws IOException {
        if (this.isClosed()) {
            return;
        }
        assert (this.r == null || this.r_is_exhausted());
        do {
            if (this.r != null && this.r.hasDone() && this.r.getDone()) {
                this.close();
                return;
            }
            try {
                byte[] data = this.conn.receive(18);
                if (data == null) {
                    this.close();
                    throw new IOException("received empty response");
                }
                this.r = RPB.RpbListKeysResp.parseFrom(data);
                this.i = 0;
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        } while (this.r.getKeysCount() == 0);
    }
}

