/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.client.http.BinIndex;
import com.basho.riak.client.http.IntIndex;
import com.basho.riak.client.http.RiakIndex;
import com.basho.riak.pbc.RPB;
import com.basho.riak.pbc.RiakLink;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakObject {
    private ByteString vclock;
    private ByteString bucket;
    private ByteString key;
    private ByteString value;
    private String contentType;
    private List<RiakLink> links = Collections.synchronizedList(new ArrayList());
    private final Object indexLock = new Object();
    private List<RiakIndex> indexes = new ArrayList<RiakIndex>();
    private String vtag;
    private String contentEncoding;
    private String charset;
    private Object userMetaDataLock = new Object();
    private Map<String, String> userMetaData = new LinkedHashMap<String, String>();
    private Integer lastModified;
    private Integer lastModifiedUsec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RiakObject(ByteString vclock, ByteString bucket, ByteString key, RPB.RpbContent content) {
        this.vclock = vclock;
        this.bucket = bucket;
        this.key = key;
        this.value = content.getValue();
        this.contentType = this.str(content.getContentType());
        this.charset = this.str(content.getCharset());
        this.contentEncoding = this.str(content.getContentEncoding());
        this.vtag = this.str(content.getVtag());
        List<Object> list = this.links = content.getLinksCount() == 0 ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(RiakLink.decode(content.getLinksList()));
        if (content.hasLastMod()) {
            this.lastModified = new Integer(content.getLastMod());
            this.lastModifiedUsec = new Integer(content.getLastModUsecs());
        }
        if (content.getUsermetaCount() > 0) {
            LinkedHashMap<String, String> tmpUserMetaData = new LinkedHashMap<String, String>();
            for (int i = 0; i < content.getUsermetaCount(); ++i) {
                RPB.RpbPair um = content.getUsermeta(i);
                tmpUserMetaData.put(um.getKey().toStringUtf8(), this.str(um.getValue()));
            }
            Object i = this.userMetaDataLock;
            synchronized (i) {
                this.userMetaData.putAll(tmpUserMetaData);
            }
        }
        if (content.getIndexesCount() > 0) {
            ArrayList<RiakIndex> indexes = new ArrayList<RiakIndex>();
            for (RPB.RpbPair p : content.getIndexesList()) {
                String name = p.getKey().toStringUtf8();
                String value = p.getValue().toStringUtf8();
                if (name.endsWith("_bin")) {
                    indexes.add(new BinIndex(name, value));
                    continue;
                }
                if (name.endsWith("_int")) {
                    indexes.add(new IntIndex(name, Integer.parseInt(value)));
                    continue;
                }
                throw new RuntimeException("unkown index type " + name);
            }
            Object object = this.indexLock;
            synchronized (object) {
                this.indexes.addAll(indexes);
            }
        }
    }

    public RiakObject(ByteString vclock, ByteString bucket, ByteString key, ByteString content) {
        this.bucket = bucket;
        this.key = key;
        this.value = content;
        this.vclock = vclock;
    }

    public RiakObject(ByteString bucket, ByteString key, ByteString content) {
        this.bucket = bucket;
        this.key = key;
        this.value = content;
    }

    public RiakObject(String bucket, String key, byte[] content) {
        this.bucket = ByteString.copyFromUtf8((String)bucket);
        this.key = ByteString.copyFromUtf8((String)key);
        this.value = ByteString.copyFrom((byte[])content);
    }

    public RiakObject(String bucket, String key, String content) {
        this.bucket = ByteString.copyFromUtf8((String)bucket);
        this.key = ByteString.copyFromUtf8((String)key);
        this.value = ByteString.copyFromUtf8((String)content);
    }

    private String str(ByteString str) {
        if (str == null) {
            return null;
        }
        return str.toStringUtf8();
    }

    public ByteString getBucketBS() {
        return this.bucket;
    }

    public String getBucket() {
        return this.bucket.toStringUtf8();
    }

    public ByteString getKeyBS() {
        return this.key;
    }

    public String getKey() {
        return this.key.toStringUtf8();
    }

    public ByteString getVclock() {
        return this.vclock;
    }

    public ByteString getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RPB.RpbContent buildContent() {
        Object object;
        RPB.RpbContent.Builder b = RPB.RpbContent.newBuilder().setValue(this.value);
        if (this.contentType != null) {
            b.setContentType(ByteString.copyFromUtf8((String)this.contentType));
        }
        if (this.charset != null) {
            b.setCharset(ByteString.copyFromUtf8((String)this.charset));
        }
        if (this.contentEncoding != null) {
            b.setContentEncoding(ByteString.copyFromUtf8((String)this.contentEncoding));
        }
        if (this.vtag != null) {
            b.setVtag(ByteString.copyFromUtf8((String)this.vtag));
        }
        if (this.links.size() != 0) {
            RiakLink[] localLinks = null;
            object = this.links;
            synchronized (object) {
                localLinks = this.links.toArray(new RiakLink[this.links.size()]);
            }
            for (RiakLink l : localLinks) {
                b.addLinks(l.build());
            }
        }
        if (this.lastModified != null) {
            b.setLastMod(this.lastModified);
        }
        if (this.lastModifiedUsec != null) {
            b.setLastModUsecs(this.lastModifiedUsec);
        }
        LinkedHashMap<String, String> tmpUserMetaData = new LinkedHashMap<String, String>();
        RiakLink[] arr$ = this.userMetaDataLock;
        synchronized (this.userMetaDataLock) {
            tmpUserMetaData.putAll(this.userMetaData);
            // ** MonitorExit[arr$] (shouldn't be in output)
            if (tmpUserMetaData != null && !tmpUserMetaData.isEmpty()) {
                for (Map.Entry ent : tmpUserMetaData.entrySet()) {
                    ByteString key = ByteString.copyFromUtf8((String)((String)ent.getKey()));
                    RPB.RpbPair.Builder pb = RPB.RpbPair.newBuilder().setKey(key);
                    if (ent.getValue() != null) {
                        pb.setValue(ByteString.copyFromUtf8((String)((String)ent.getValue())));
                    }
                    b.addUsermeta(pb);
                }
            }
            object = this.indexLock;
            synchronized (object) {
                for (RiakIndex i : this.indexes) {
                    b.addIndexes(RPB.RpbPair.newBuilder().setKey(ByteString.copyFromUtf8((String)i.getName())).setValue(ByteString.copyFromUtf8((String)i.getValue().toString())).build());
                }
            }
            return b.build();
        }
    }

    public String getVtag() {
        return this.vtag;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void addLink(String tag, String bucket, String key) {
        this.links.add(new RiakLink(bucket, key, tag));
    }

    public void addLink(ByteString tag, ByteString bucket, ByteString key) {
        this.links.add(new RiakLink(bucket, key, tag));
    }

    public List<RiakLink> getLinks() {
        return this.links != null ? Collections.unmodifiableList(this.links) : Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getUsermeta() {
        Object object = this.userMetaDataLock;
        synchronized (object) {
            return new LinkedHashMap<String, String>(this.userMetaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject addUsermetaItem(String key, String value) {
        Object object = this.userMetaDataLock;
        synchronized (object) {
            this.userMetaData.put(key, value);
        }
        return this;
    }

    public Date getLastModified() {
        Date d = null;
        if (this.lastModified != null && this.lastModifiedUsec != null) {
            long t = (long)this.lastModified.intValue() * 1000L + (long)this.lastModifiedUsec.intValue() / 1000L;
            d = new Date(t);
        }
        return d;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RiakIndex> getIndexes() {
        Object object = this.indexLock;
        synchronized (object) {
            return new ArrayList<RiakIndex>(this.indexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject addIndex(String name, String value) {
        Object object = this.indexLock;
        synchronized (object) {
            this.indexes.add(new BinIndex(name, value));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakObject addIndex(String name, int value) {
        Object object = this.indexLock;
        synchronized (object) {
            this.indexes.add(new IntIndex(name, value));
        }
        return this;
    }
}

