/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.annotation;

import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndex;
import com.frameworkset.orm.annotation.NameParserException;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.util.DataFormatUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.frameworkset.util.tokenizer.TextGrammarParser;

public class ESIndexWrapper {
    private static TextGrammarParser.GrammarTokenBuilder<NameGrammarToken> nameGrammarTokenBuilder = new NameGrammarTokenBuilder();
    private NameInfo nameInfo;
    private TypeInfo typeInfo;
    private String index;
    private String type;
    private ESIndex esIndex;

    public NameInfo getNameInfo() {
        return this.nameInfo;
    }

    public void setNameInfo(NameInfo nameInfo) {
        this.nameInfo = nameInfo;
    }

    public ESIndex getEsIndex() {
        return this.esIndex;
    }

    public void setEsIndex(ESIndex esIndex) {
        this.esIndex = esIndex;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private static Map<String, String> parserVarinfo(String var) {
        int idx = var.indexOf("=");
        HashMap<String, String> varinfo = new HashMap<String, String>();
        if (idx > 0) {
            String[] arr = var.split(",");
            for (int i = 0; i < arr.length; ++i) {
                String e = arr[i];
                String[] attr = e.split("=");
                if (attr.length == 1) {
                    throw new NameParserException("varible syntax error:" + var + "," + e + " must be a express like xxx=vvvv");
                }
                varinfo.put(attr[0], attr[1]);
            }
        } else {
            idx = var.indexOf(",");
            if (idx > 0) {
                String[] datas = var.split(",");
                varinfo.put("field", datas[0].trim());
                varinfo.put("dateformat", datas[1].trim());
            } else {
                varinfo.put("field", var);
            }
        }
        return varinfo;
    }

    public ESIndexWrapper(ESIndex esIndex) {
        this.esIndex = esIndex;
        this.initInfo(esIndex.name(), esIndex.type());
    }

    public ESIndexWrapper(String indexPattern, String typePattern) {
        this.initInfo(indexPattern, typePattern);
    }

    private void initInfo(String name, String type) {
        NameGrammarToken token;
        int i;
        this.index = name;
        this.type = type;
        this.nameInfo = new NameInfo();
        List<NameGrammarToken> tokens = TextGrammarParser.parser(this.index, '{', '}', nameGrammarTokenBuilder);
        boolean varibled = false;
        int varcount = 0;
        NameGrammarToken one = null;
        for (i = 0; tokens != null && i < tokens.size(); ++i) {
            token = tokens.get(i);
            if (!token.varibletoken()) continue;
            varibled = true;
            ++varcount;
            if (one != null) continue;
            one = token;
        }
        if (varibled) {
            this.nameInfo.tokens = tokens;
            if (varcount == 1 && one.getFieldName() == null) {
                this.nameInfo.onlyCurrentDateTimestamp = true;
            }
        } else {
            this.nameInfo.name = this.index;
        }
        if (type != null) {
            varcount = 0;
            one = null;
            this.typeInfo = new TypeInfo();
            tokens = TextGrammarParser.parser(type, '{', '}', nameGrammarTokenBuilder);
            varibled = false;
            for (i = 0; tokens != null && i < tokens.size(); ++i) {
                token = tokens.get(i);
                if (!token.varibletoken()) continue;
                varibled = true;
                ++varcount;
                if (one != null) continue;
                one = token;
            }
            if (varibled) {
                this.typeInfo.tokens = tokens;
            } else {
                this.typeInfo.type = type;
            }
        }
    }

    public void buildIndexName(Writer writer, GetVariableValue getVariableValue) throws IOException {
        this.nameInfo.buildName(writer, getVariableValue);
    }

    public void buildIndexName(StringBuilder builder, GetVariableValue getVariableValue) {
        this.nameInfo.buildName(builder, getVariableValue);
    }

    public String buildIndexName(GetVariableValue getVariableValue) {
        return this.nameInfo.buildName(getVariableValue);
    }

    public void buildIndexType(Writer writer, GetVariableValue getVariableValue) throws IOException {
        this.typeInfo.buildType(writer, getVariableValue);
    }

    public void buildIndexType(StringBuilder builder, GetVariableValue getVariableValue) {
        this.typeInfo.buildType(builder, getVariableValue);
    }

    public String buildIndexType(GetVariableValue getVariableValue) {
        return this.typeInfo.buildType(getVariableValue);
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public static class NameGrammarTokenBuilder
    implements TextGrammarParser.GrammarTokenBuilder<NameGrammarToken> {
        @Override
        public NameGrammarToken buildGrammarToken() {
            return new NameGrammarToken();
        }
    }

    public static class NameGrammarToken
    extends TextGrammarParser.GrammarToken {
        protected String fieldName;
        protected DateFormateMeta dateFormateMeta;
        protected String dateformat;

        @Override
        public void after() {
            try {
                if (this.varibletoken()) {
                    Map varinfo = ESIndexWrapper.parserVarinfo(this.text);
                    this.fieldName = (String)varinfo.get("field");
                    this.dateformat = (String)varinfo.get("dateformat");
                    if (this.dateformat != null) {
                        this.dateFormateMeta = DateFormateMeta.buildDateFormateMeta(this.dateformat);
                    }
                }
            }
            catch (Exception e) {
                throw new NameParserException(this.toString(), e);
            }
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public DateFormateMeta getDateFormateMeta() {
            return this.dateFormateMeta;
        }
    }

    public static class TypeInfo {
        private String type;
        private List<NameGrammarToken> tokens;

        private void buildType(Writer writer, GetVariableValue getVariableValue) throws IOException {
            if (this.type != null) {
                writer.write(this.type);
                return;
            }
            if (this.tokens == null || this.tokens.size() == 0) {
                return;
            }
            BatchContext batchContext = getVariableValue.getBatchContext();
            if (batchContext != null && batchContext.getIndexType() != null) {
                writer.write(batchContext.getIndexType());
                return;
            }
            NameGrammarToken nameGrammarToken = null;
            for (int i = 0; i < this.tokens.size(); ++i) {
                nameGrammarToken = this.tokens.get(i);
                if (!nameGrammarToken.varibletoken()) {
                    writer.write(nameGrammarToken.getText());
                    continue;
                }
                Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
                if (va == null) {
                    throw new NameParserException(this.toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
                }
                writer.write(String.valueOf(va));
            }
        }

        private void buildType(StringBuilder builder, GetVariableValue getVariableValue) {
            if (this.type != null) {
                builder.append(this.type);
                return;
            }
            if (this.tokens == null || this.tokens.size() == 0) {
                return;
            }
            BatchContext batchContext = getVariableValue.getBatchContext();
            if (batchContext != null && batchContext.getIndexType() != null) {
                builder.append(batchContext.getIndexType());
                return;
            }
            NameGrammarToken nameGrammarToken = null;
            for (int i = 0; i < this.tokens.size(); ++i) {
                nameGrammarToken = this.tokens.get(i);
                if (!nameGrammarToken.varibletoken()) {
                    builder.append(nameGrammarToken.getText());
                    continue;
                }
                Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
                if (va == null) {
                    throw new NameParserException(this.toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
                }
                builder.append(va);
            }
        }

        public String buildType(GetVariableValue getVariableValue) {
            if (this.type == null || this.type.equals("")) {
                if (this.tokens == null || this.tokens.size() == 0) {
                    return null;
                }
            } else {
                return this.type;
            }
            BatchContext batchContext = getVariableValue.getBatchContext();
            if (batchContext != null && batchContext.getIndexType() != null) {
                return batchContext.getIndexType();
            }
            StringBuilder builder = new StringBuilder();
            this.buildType(builder, getVariableValue);
            return builder.toString();
        }
    }

    public static class NameInfo {
        protected String name;
        protected boolean onlyCurrentDateTimestamp;
        private List<NameGrammarToken> tokens;

        public String getName() {
            return this.name;
        }

        public boolean isOnlyCurrentDateTimestamp() {
            return this.onlyCurrentDateTimestamp;
        }

        private void buildName(Writer writer, GetVariableValue getVariableValue) throws IOException {
            if (this.name != null) {
                writer.write(this.name);
                return;
            }
            if (this.tokens == null || this.tokens.size() == 0) {
                return;
            }
            BatchContext batchContext = getVariableValue.getBatchContext();
            if (batchContext != null && batchContext.getIndexName() != null) {
                writer.write(batchContext.getIndexName());
                return;
            }
            NameGrammarToken nameGrammarToken = null;
            StringBuilder temp = this.onlyCurrentDateTimestamp && batchContext != null && batchContext.getIndexName() == null ? new StringBuilder() : null;
            for (int i = 0; i < this.tokens.size(); ++i) {
                nameGrammarToken = this.tokens.get(i);
                if (!nameGrammarToken.varibletoken()) {
                    if (temp != null) {
                        temp.append(nameGrammarToken.getText());
                    }
                    writer.write(nameGrammarToken.getText());
                    continue;
                }
                if (nameGrammarToken.getFieldName() != null) {
                    Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
                    if (va == null) {
                        throw new NameParserException(this.toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
                    }
                    if (nameGrammarToken.dateformat != null) {
                        SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat(nameGrammarToken.dateformat);
                        if (va instanceof Date) {
                            writer.write(dateFormat.format((Date)va));
                            continue;
                        }
                        if (va instanceof Long) {
                            writer.write(dateFormat.format(new Date((Long)va)));
                            continue;
                        }
                        writer.write(String.valueOf(va));
                        continue;
                    }
                    writer.write(String.valueOf(va));
                    continue;
                }
                SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat(nameGrammarToken.dateformat);
                Date date = new Date();
                String d = dateFormat.format(date);
                writer.write(d);
                if (temp == null) continue;
                temp.append(d);
            }
            if (temp != null) {
                batchContext.setIndexName(temp.toString());
            }
        }

        private void buildName(StringBuilder builder, GetVariableValue getVariableValue) {
            if (this.name != null) {
                builder.append(this.name);
                return;
            }
            if (this.tokens == null || this.tokens.size() == 0) {
                return;
            }
            BatchContext batchContext = getVariableValue.getBatchContext();
            if (batchContext != null && batchContext.getIndexName() != null) {
                builder.append(batchContext.getIndexName());
                return;
            }
            NameGrammarToken nameGrammarToken = null;
            StringBuilder temp = this.onlyCurrentDateTimestamp && batchContext != null && batchContext.getIndexName() == null ? new StringBuilder() : null;
            for (int i = 0; i < this.tokens.size(); ++i) {
                nameGrammarToken = this.tokens.get(i);
                if (!nameGrammarToken.varibletoken()) {
                    if (temp != null) {
                        temp.append(nameGrammarToken.getText());
                    }
                    builder.append(nameGrammarToken.getText());
                    continue;
                }
                if (nameGrammarToken.getFieldName() != null) {
                    Object va = getVariableValue.getValue(nameGrammarToken.getFieldName());
                    if (va == null) {
                        throw new NameParserException(this.toString() + ",property[" + nameGrammarToken.getFieldName() + "] is null.");
                    }
                    if (nameGrammarToken.dateformat != null) {
                        SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat(nameGrammarToken.dateformat);
                        if (va instanceof Date) {
                            builder.append(dateFormat.format((Date)va));
                            continue;
                        }
                        if (va instanceof Long) {
                            builder.append(dateFormat.format(new Date((Long)va)));
                            continue;
                        }
                        builder.append(va);
                        continue;
                    }
                    builder.append(va);
                    continue;
                }
                SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat(nameGrammarToken.dateformat);
                Date date = new Date();
                String d = dateFormat.format(date);
                builder.append(d);
                if (temp == null) continue;
                temp.append(d);
            }
            if (temp != null) {
                batchContext.setIndexName(temp.toString());
            }
        }

        public String buildName(GetVariableValue getVariableValue) {
            if (this.name == null || this.name.equals("")) {
                if (this.tokens == null || this.tokens.size() == 0) {
                    return null;
                }
            } else {
                return this.name;
            }
            BatchContext batchContext = getVariableValue.getBatchContext();
            if (batchContext != null && batchContext.getIndexName() != null) {
                return batchContext.getIndexName();
            }
            StringBuilder builder = new StringBuilder();
            this.buildName(builder, getVariableValue);
            return builder.toString();
        }
    }

    public static interface GetVariableValue {
        public Object getValue(String var1);

        public BatchContext getBatchContext();

        public void setBatchContext(BatchContext var1);
    }
}

