/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MissingStaticCache<K, V> {
    private final int size;
    public final int DEFAULT_SIZE = 1000;
    private final Map<K, V> eden;
    private int misses;
    private int missesMax;
    private boolean stopCache;

    public MissingStaticCache() {
        this.size = 1000;
        this.missesMax = this.size * 2;
        this.eden = new ConcurrentHashMap();
    }

    public MissingStaticCache(int size) {
        this.size = size;
        this.missesMax = size * 2;
        this.eden = new ConcurrentHashMap();
    }

    public int getMissesMax() {
        return this.missesMax;
    }

    private void shouldCache() {
        if (this.misses >= this.missesMax) {
            this.stopCache = true;
            this.clear();
        }
    }

    public boolean stopCache() {
        return this.stopCache;
    }

    public void clear() {
        this.eden.clear();
    }

    public int increamentMissing() {
        ++this.misses;
        this.shouldCache();
        return this.misses;
    }

    public V get(K k) {
        V v = this.eden.get(k);
        return v;
    }

    public void put(K k, V v) {
        this.eden.put(k, v);
    }

    public int edenSize() {
        return this.eden.size();
    }
}

