/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.frameworkset.security.AccessControlFactory;
import org.frameworkset.security.AccessControlInf;
import org.frameworkset.security.DefaultAccessControlFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static Logger log = LoggerFactory.getLogger(SecurityUtil.class);
    private static AccessControlFactory accessControlFactory;

    public static AccessControlInf getAccessControl(HttpServletRequest request, HttpServletResponse response, JspWriter out) {
        return accessControlFactory.getAccessControl(request, response, out);
    }

    static {
        try {
            accessControlFactory = (AccessControlFactory)Class.forName("com.frameworkset.platform.security.PlatformAccessControlFactoryImpl").newInstance();
            log.info("AccessControlFactory is com.frameworkset.platform.security.PlatformAccessControlFactoryImpl");
        }
        catch (Exception e) {
            try {
                accessControlFactory = (AccessControlFactory)Class.forName("org.frameworkset.platform.security.PlatformAccessControlFactoryImpl").newInstance();
                log.info("AccessControlFactory is org.frameworkset.platform.security.PlatformAccessControlFactoryImpl");
            }
            catch (Exception e1) {
                log.info("AccessControlFactory is DefaultAccessControlFactoryImpl");
                accessControlFactory = new DefaultAccessControlFactoryImpl();
            }
        }
    }
}

