/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import com.frameworkset.util.StringUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.frameworkset.util.AntPathMatcher;
import org.frameworkset.util.PathMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferHelper {
    private static Logger logger = LoggerFactory.getLogger(ReferHelper.class);
    private String[] refererwallwhilelist;
    public static final String REQUEST_HEADER_REFER_CHECKED = "REQUEST_HEADER_REFER_CHECKED";
    public static final String REQUEST_HEADER_ORIGIN = "Origin";
    public static final String REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private boolean refererDefender = false;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private String[] wallfilterrules;
    private String[] wallwhilelist;
    public static final String[] wallfilterrules_default = new String[]{"<script", "%3Cscript", "script", "<img", "%3Cimg", "alert(", "alert%28", "eval(", "eval%28", "style=", "style%3D", "javascript", "update ", "drop ", "delete ", "insert ", "create ", "select ", "truncate "};

    private boolean iswhilerefer(String referer) {
        if (this.refererwallwhilelist == null || this.refererwallwhilelist.length == 0) {
            return false;
        }
        for (String whilereferername : this.refererwallwhilelist) {
            if (!this.pathMatcher.urlContain(whilereferername, referer)) continue;
            return true;
        }
        return false;
    }

    public void recordNoCros(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(REQUEST_HEADER_REFER_CHECKED, (Object)false);
    }

    public boolean dorefer(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean checked = (Boolean)request.getAttribute(REQUEST_HEADER_REFER_CHECKED);
        if (checked != null) {
            return checked;
        }
        if (this.refererDefender) {
            String referer = request.getHeader("Referer");
            if (referer != null) {
                String basePath = null;
                String basePath80 = null;
                if (!request.getContextPath().equals("/")) {
                    if (request.getServerPort() != 80) {
                        basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
                    } else {
                        basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
                        basePath80 = request.getScheme() + "://" + request.getServerName() + request.getContextPath() + "/";
                    }
                } else if (request.getServerPort() != 80) {
                    basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                } else {
                    basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                    basePath80 = request.getScheme() + "://" + request.getServerName() + request.getContextPath();
                }
                if (basePath80 == null) {
                    if (referer.indexOf(basePath) < 0) {
                        if (this.iswhilerefer(referer)) {
                            checked = false;
                        } else {
                            this.sendInvalidCORS(request, response);
                            checked = true;
                        }
                    }
                } else if (referer.indexOf(basePath) < 0 && referer.indexOf(basePath80) < 0) {
                    if (this.iswhilerefer(referer)) {
                        checked = false;
                    } else {
                        this.sendInvalidCORS(request, response);
                        checked = true;
                    }
                }
            }
        } else {
            checked = false;
        }
        request.setAttribute(REQUEST_HEADER_REFER_CHECKED, (Object)checked);
        return checked;
    }

    public void sendInvalidCORS(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader(REQUEST_HEADER_ORIGIN);
        String method = request.getMethod();
        String accessControlRequestHeaders = request.getHeader(REQUEST_HEADER_ACCESS_CONTROL_REQUEST_HEADERS);
        response.setContentType("text/plain");
        response.setStatus(403);
        response.resetBuffer();
        if (logger.isDebugEnabled()) {
            StringBuilder message = new StringBuilder("Invalid CORS request; Origin=");
            message.append(origin);
            message.append(";Method=");
            message.append(method);
            if (accessControlRequestHeaders != null) {
                message.append(";Access-Control-Request-Headers=");
                message.append(accessControlRequestHeaders);
            }
            logger.debug(message.toString());
        }
    }

    public void sendRedirect403(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!response.isCommitted()) {
            response.sendError(403);
        }
    }

    public String[] getRefererwallwhilelist() {
        return this.refererwallwhilelist;
    }

    public void setRefererwallwhilelist(String[] refererwallwhilelist) {
        this.refererwallwhilelist = refererwallwhilelist;
        if (StringUtil.isNotEmpty(this.refererwallwhilelist)) {
            for (int i = 0; i < this.refererwallwhilelist.length; ++i) {
                this.refererwallwhilelist[i] = this.refererwallwhilelist[i].trim();
            }
        }
    }

    public boolean isRefererDefender() {
        return this.refererDefender;
    }

    public void setRefererDefender(boolean refererDefender) {
        this.refererDefender = refererDefender;
    }

    public String[] getWallfilterrules() {
        return this.wallfilterrules;
    }

    public void setWallfilterrules(String[] wallfilterrules) {
        this.wallfilterrules = wallfilterrules;
    }

    public String[] getWallwhilelist() {
        return this.wallwhilelist;
    }

    public void setWallwhilelist(String[] wallwhilelist) {
        this.wallwhilelist = wallwhilelist;
    }

    public boolean iswhilename(String name) {
        if (this.wallwhilelist == null || this.wallwhilelist.length == 0) {
            return true;
        }
        for (String whilename : this.wallwhilelist) {
            if (!whilename.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void wallfilter(String name, String[] values) {
        if (this.wallfilterrules == null || this.wallfilterrules.length == 0 || values == null || values.length == 0 || this.iswhilename(name)) {
            return;
        }
        int j = 0;
        for (String value : values) {
            if (value == null || value.equals("")) {
                ++j;
                continue;
            }
            for (int i = 0; i < this.wallfilterrules.length; ++i) {
                if (value.indexOf(this.wallfilterrules[i]) < 0) continue;
                values[j] = null;
                if (!logger.isWarnEnabled()) break;
                logger.warn("\u53c2\u6570" + name + "\u503c" + value + "\u5305\u542b\u654f\u611f\u8bcd:" + this.wallfilterrules[i] + ",\u5b58\u5728\u5b89\u5168\u9690\u60a3,\u7cfb\u7edf\u81ea\u52a8\u8fc7\u6ee4\u6389\u53c2\u6570\u503c!");
                break;
            }
            ++j;
        }
    }
}

