/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations.wraper;

import java.io.File;
import java.lang.reflect.Method;
import java.sql.Blob;
import org.frameworkset.http.FileBlob;
import org.frameworkset.http.MediaType;
import org.frameworkset.util.annotations.AnnotationUtils;
import org.frameworkset.util.annotations.ResponseBody;
import org.frameworkset.util.io.Resource;

public class ResponseBodyWraper {
    private static Class rsschannel = null;
    private static Class atomFeed = null;
    private MediaType responseMediaType;
    private static Class wordResponse = null;
    private String datatype;
    private boolean eval = false;
    private String charset;

    private String evalDataType(Class responseClass) {
        if (String.class.isAssignableFrom(responseClass)) {
            this.eval = true;
            return "String";
        }
        if (File.class.isAssignableFrom(responseClass) || FileBlob.class.isAssignableFrom(responseClass) || Blob.class.isAssignableFrom(responseClass) || Resource.class.isAssignableFrom(responseClass)) {
            return "file";
        }
        if (byte[].class.isAssignableFrom(responseClass)) {
            return "bytearray";
        }
        if (rsschannel != null && rsschannel.isAssignableFrom(responseClass)) {
            return "rss";
        }
        if (atomFeed != null && atomFeed.isAssignableFrom(responseClass)) {
            return "atom";
        }
        if (wordResponse != null && wordResponse.isAssignableFrom(responseClass)) {
            return "word";
        }
        if (Enum.class.isAssignableFrom(responseClass)) {
            this.eval = true;
            return "String";
        }
        return "json";
    }

    public ResponseBodyWraper(ResponseBody body, Method method) {
        this.datatype = AnnotationUtils.converDefaultValue(body.datatype());
        if (this.datatype == null) {
            this.datatype = this.evalDataType(method.getReturnType());
        }
        this.charset = AnnotationUtils.converDefaultValue(body.charset());
        this.responseMediaType = this.convertMediaType();
    }

    public ResponseBodyWraper(String datatype, String charset, Class bodyType) {
        this.datatype = datatype;
        if (this.datatype == null) {
            this.datatype = this.evalDataType(bodyType);
        }
        this.charset = charset;
        this.responseMediaType = this.convertMediaType();
    }

    private MediaType convertMediaType() {
        String type = this.datatype();
        String charset = this.charset();
        return MediaType.convertMediaType(type, charset);
    }

    public String datatype() {
        return this.datatype;
    }

    public String charset() {
        return this.charset;
    }

    public MediaType getResponseMediaType() {
        return this.responseMediaType;
    }

    public boolean isEval() {
        return this.eval;
    }

    static {
        try {
            wordResponse = Class.forName("org.frameworkset.http.converter.wordpdf.WordResponse");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            rsschannel = Class.forName("com.sun.syndication.feed.rss.Channel");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            atomFeed = Class.forName("com.sun.syndication.feed.atom.Feed");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

