/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.asm;

import bboss.org.objectweb.asm.ClassReader;
import bboss.org.objectweb.asm.ClassWriter;
import java.util.List;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.asm.ASMClassLoader;
import org.frameworkset.util.asm.ASMPUTGETFieldAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsmUtil {
    private static final ASMClassLoader classLoader = new ASMClassLoader();
    private static final Logger log = LoggerFactory.getLogger(AsmUtil.class);
    public static final String bboss_field_getMethod_prex = "___bboss_pull";
    public static final String bboss_field_setMethod_prex = "___bboss_put";

    public static Class addGETSETMethodForClass(List<ClassUtil.PropertieDescription> propertieDescriptionies, Class beanType) {
        String className = beanType.getName();
        try {
            ClassReader cr = new ClassReader(className);
            ClassWriter cw = new ClassWriter(1);
            cr.accept(new ASMPUTGETFieldAdapter(cw, beanType, propertieDescriptionies), 0);
            beanType = classLoader.defineClass(className, cw.toByteArray());
            return beanType;
        }
        catch (Exception e) {
            log.error("Add field's GET/SET Method For [" + className + "] failed:", (Throwable)e);
            return beanType;
        }
    }
}

