/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.frameworkset.util.beans.BeansException;

public class BeanWrapper {
    private Object wrappedInstance;
    private BeanInfo beanInfo;

    public BeanWrapper(Object target) {
        this.setWrappedInstance(target);
    }

    public void setWrappedInstance(Object obj) {
        this.wrappedInstance = obj;
        try {
            this.beanInfo = this.wrappedInstance == null ? null : Introspector.getBeanInfo(this.wrappedInstance.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public Object getWrappedInstance() {
        return this.wrappedInstance;
    }

    public Class getWrappedClass() {
        return this.wrappedInstance == null ? null : this.wrappedInstance.getClass();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.beanInfo == null ? null : this.beanInfo.getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        PropertyDescriptor[] pds = this.getPropertyDescriptors();
        if (pds == null) {
            return null;
        }
        for (PropertyDescriptor pd : pds) {
            if (!pd.getName().equals(propertyName)) continue;
            return pd;
        }
        return null;
    }

    public Class getPropertyType(String fixedField) {
        PropertyDescriptor pd = this.getPropertyDescriptor(fixedField);
        return pd == null ? null : pd.getPropertyType();
    }

    public Object getPropertyValue(String field) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor pd = this.getPropertyDescriptor(field);
        return pd == null ? null : pd.getReadMethod().invoke(this.wrappedInstance, null);
    }
}

