/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerBitString;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.jasn1.ber.types.string.BerGraphicString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AuthenticationValue implements BerType, Serializable {

  private static final long serialVersionUID = 1L;

  public byte[] code = null;
  private BerGraphicString charstring = null;
  private BerBitString bitstring = null;
  private Myexternal2 external = null;

  public AuthenticationValue() {}

  public AuthenticationValue(byte[] code) {
    this.code = code;
  }

  public BerGraphicString getCharstring() {
    return charstring;
  }

  public void setCharstring(BerGraphicString charstring) {
    this.charstring = charstring;
  }

  public BerBitString getBitstring() {
    return bitstring;
  }

  public void setBitstring(BerBitString bitstring) {
    this.bitstring = bitstring;
  }

  public Myexternal2 getExternal() {
    return external;
  }

  public void setExternal(Myexternal2 external) {
    this.external = external;
  }

  public int encode(OutputStream reverseOS) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      return code.length;
    }

    int codeLength = 0;
    if (external != null) {
      codeLength += external.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 2
      reverseOS.write(0xA2);
      codeLength += 1;
      return codeLength;
    }

    if (bitstring != null) {
      codeLength += bitstring.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 1
      reverseOS.write(0x81);
      codeLength += 1;
      return codeLength;
    }

    if (charstring != null) {
      codeLength += charstring.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 0
      reverseOS.write(0x80);
      codeLength += 1;
      return codeLength;
    }

    throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, null);
  }

  public int decode(InputStream is, BerTag berTag) throws IOException {

    int codeLength = 0;
    BerTag passedTag = berTag;

    if (berTag == null) {
      berTag = new BerTag();
      codeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
      charstring = new BerGraphicString();
      codeLength += charstring.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
      bitstring = new BerBitString();
      codeLength += bitstring.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 2)) {
      external = new Myexternal2();
      codeLength += external.decode(is, false);
      return codeLength;
    }

    if (passedTag != null) {
      return 0;
    }

    throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    if (charstring != null) {
      sb.append("charstring: ").append(charstring);
      return;
    }

    if (bitstring != null) {
      sb.append("bitstring: ").append(bitstring);
      return;
    }

    if (external != null) {
      sb.append("external: ");
      external.appendAsString(sb, indentLevel + 1);
      return;
    }

    sb.append("<none>");
  }
}
