/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AccessResult implements BerType, Serializable {

  private static final long serialVersionUID = 1L;

  public byte[] code = null;
  private DataAccessError failure = null;
  private Data success = null;

  public AccessResult() {}

  public AccessResult(byte[] code) {
    this.code = code;
  }

  public DataAccessError getFailure() {
    return failure;
  }

  public void setFailure(DataAccessError failure) {
    this.failure = failure;
  }

  public Data getSuccess() {
    return success;
  }

  public void setSuccess(Data success) {
    this.success = success;
  }

  public int encode(OutputStream reverseOS) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      return code.length;
    }

    int codeLength = 0;
    if (success != null) {
      codeLength += success.encode(reverseOS);
      return codeLength;
    }

    if (failure != null) {
      codeLength += failure.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 0
      reverseOS.write(0x80);
      codeLength += 1;
      return codeLength;
    }

    throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, null);
  }

  public int decode(InputStream is, BerTag berTag) throws IOException {

    int codeLength = 0;
    BerTag passedTag = berTag;

    if (berTag == null) {
      berTag = new BerTag();
      codeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
      failure = new DataAccessError();
      codeLength += failure.decode(is, false);
      return codeLength;
    }

    success = new Data();
    int choiceDecodeLength = success.decode(is, berTag);
    if (choiceDecodeLength != 0) {
      return codeLength + choiceDecodeLength;
    } else {
      success = null;
    }

    if (passedTag != null) {
      return 0;
    }

    throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    if (failure != null) {
      sb.append("failure: ").append(failure);
      return;
    }

    if (success != null) {
      sb.append("success: ");
      success.appendAsString(sb, indentLevel + 1);
      return;
    }

    sb.append("<none>");
  }
}
