/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerNull;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class GetNameListRequest implements BerType, Serializable {

  public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
  private static final long serialVersionUID = 1L;
  public byte[] code = null;
  private ObjectClass objectClass = null;
  private ObjectScope objectScope = null;
  private Identifier continueAfter = null;

  public GetNameListRequest() {}

  public GetNameListRequest(byte[] code) {
    this.code = code;
  }

  public ObjectClass getObjectClass() {
    return objectClass;
  }

  public void setObjectClass(ObjectClass objectClass) {
    this.objectClass = objectClass;
  }

  public ObjectScope getObjectScope() {
    return objectScope;
  }

  public void setObjectScope(ObjectScope objectScope) {
    this.objectScope = objectScope;
  }

  public Identifier getContinueAfter() {
    return continueAfter;
  }

  public void setContinueAfter(Identifier continueAfter) {
    this.continueAfter = continueAfter;
  }

  public int encode(OutputStream reverseOS) throws IOException {
    return encode(reverseOS, true);
  }

  public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      if (withTag) {
        return tag.encode(reverseOS) + code.length;
      }
      return code.length;
    }

    int codeLength = 0;
    int sublength;

    if (continueAfter != null) {
      codeLength += continueAfter.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 2
      reverseOS.write(0x82);
      codeLength += 1;
    }

    sublength = objectScope.encode(reverseOS);
    codeLength += sublength;
    codeLength += BerLength.encodeLength(reverseOS, sublength);
    // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
    reverseOS.write(0xA1);
    codeLength += 1;

    sublength = objectClass.encode(reverseOS);
    codeLength += sublength;
    codeLength += BerLength.encodeLength(reverseOS, sublength);
    // write tag: CONTEXT_CLASS, CONSTRUCTED, 0
    reverseOS.write(0xA0);
    codeLength += 1;

    codeLength += BerLength.encodeLength(reverseOS, codeLength);

    if (withTag) {
      codeLength += tag.encode(reverseOS);
    }

    return codeLength;
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, true);
  }

  public int decode(InputStream is, boolean withTag) throws IOException {
    int codeLength = 0;
    int subCodeLength = 0;
    BerTag berTag = new BerTag();

    if (withTag) {
      codeLength += tag.decodeAndCheck(is);
    }

    BerLength length = new BerLength();
    codeLength += length.decode(is);

    int totalLength = length.val;
    codeLength += totalLength;

    subCodeLength += berTag.decode(is);
    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 0)) {
      subCodeLength += length.decode(is);
      objectClass = new ObjectClass();
      subCodeLength += objectClass.decode(is, null);
      subCodeLength += berTag.decode(is);
    } else {
      throw new IOException("Tag does not match the mandatory sequence element tag.");
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
      subCodeLength += length.decode(is);
      objectScope = new ObjectScope();
      subCodeLength += objectScope.decode(is, null);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    } else {
      throw new IOException("Tag does not match the mandatory sequence element tag.");
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
      continueAfter = new Identifier();
      subCodeLength += continueAfter.decode(is, false);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
    }
    throw new IOException(
        "Unexpected end of sequence, length tag: "
            + totalLength
            + ", actual sequence length: "
            + subCodeLength);
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS, false);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    sb.append("{");
    sb.append("\n");
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (objectClass != null) {
      sb.append("objectClass: ");
      objectClass.appendAsString(sb, indentLevel + 1);
    } else {
      sb.append("objectClass: <empty-required-field>");
    }

    sb.append(",\n");
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (objectScope != null) {
      sb.append("objectScope: ");
      objectScope.appendAsString(sb, indentLevel + 1);
    } else {
      sb.append("objectScope: <empty-required-field>");
    }

    if (continueAfter != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("continueAfter: ").append(continueAfter);
    }

    sb.append("\n");
    for (int i = 0; i < indentLevel; i++) {
      sb.append("\t");
    }
    sb.append("}");
  }

  public static class ObjectScope implements BerType, Serializable {

    private static final long serialVersionUID = 1L;

    public byte[] code = null;
    private BerNull vmdSpecific = null;
    private Identifier domainSpecific = null;
    private BerNull aaSpecific = null;

    public ObjectScope() {}

    public ObjectScope(byte[] code) {
      this.code = code;
    }

    public BerNull getVmdSpecific() {
      return vmdSpecific;
    }

    public void setVmdSpecific(BerNull vmdSpecific) {
      this.vmdSpecific = vmdSpecific;
    }

    public Identifier getDomainSpecific() {
      return domainSpecific;
    }

    public void setDomainSpecific(Identifier domainSpecific) {
      this.domainSpecific = domainSpecific;
    }

    public BerNull getAaSpecific() {
      return aaSpecific;
    }

    public void setAaSpecific(BerNull aaSpecific) {
      this.aaSpecific = aaSpecific;
    }

    public int encode(OutputStream reverseOS) throws IOException {

      if (code != null) {
        for (int i = code.length - 1; i >= 0; i--) {
          reverseOS.write(code[i]);
        }
        return code.length;
      }

      int codeLength = 0;
      if (aaSpecific != null) {
        codeLength += aaSpecific.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 2
        reverseOS.write(0x82);
        codeLength += 1;
        return codeLength;
      }

      if (domainSpecific != null) {
        codeLength += domainSpecific.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 1
        reverseOS.write(0x81);
        codeLength += 1;
        return codeLength;
      }

      if (vmdSpecific != null) {
        codeLength += vmdSpecific.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 0
        reverseOS.write(0x80);
        codeLength += 1;
        return codeLength;
      }

      throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
      return decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {

      int codeLength = 0;
      BerTag passedTag = berTag;

      if (berTag == null) {
        berTag = new BerTag();
        codeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
        vmdSpecific = new BerNull();
        codeLength += vmdSpecific.decode(is, false);
        return codeLength;
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
        domainSpecific = new Identifier();
        codeLength += domainSpecific.decode(is, false);
        return codeLength;
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
        aaSpecific = new BerNull();
        codeLength += aaSpecific.decode(is, false);
        return codeLength;
      }

      if (passedTag != null) {
        return 0;
      }

      throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
      ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
      encode(reverseOS);
      code = reverseOS.getArray();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder();
      appendAsString(sb, 0);
      return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

      if (vmdSpecific != null) {
        sb.append("vmdSpecific: ").append(vmdSpecific);
        return;
      }

      if (domainSpecific != null) {
        sb.append("domainSpecific: ").append(domainSpecific);
        return;
      }

      if (aaSpecific != null) {
        sb.append("aaSpecific: ").append(aaSpecific);
        return;
      }

      sb.append("<none>");
    }
  }
}
