/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.velocity.tool;

import com.bernardomg.velocity.tool.HtmlTool;
import com.google.common.base.Preconditions;
import org.apache.velocity.tools.config.DefaultKey;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

@DefaultKey(value="html5UpdateTool")
public class Html5UpdateTool {
    private final HtmlTool htmlUtils = new HtmlTool();

    public final void removeNoHrefLinks(Element root) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        this.getHtmlTool().unwrap(root, "a:not([href])");
    }

    public final void removePointsFromAttr(Element root, String selector, String attr) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)selector, (Object)"Received a null pointer as selector");
        Preconditions.checkNotNull((Object)attr, (Object)"Received a null pointer as attribute");
        Elements elements = root.select(selector);
        for (Element selected : elements) {
            this.removePointsFromAttr(selected, attr);
        }
    }

    public final void updateTableHeads(Element root) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Elements tableHeadRows = root.select("table > tbody > tr:has(th)");
        for (Element row : tableHeadRows) {
            Element table = row.parent().parent();
            row.remove();
            Element thead = new Element(Tag.valueOf((String)"thead"), "");
            thead.appendChild((Node)row);
            table.prependChild((Node)thead);
        }
    }

    private final HtmlTool getHtmlTool() {
        return this.htmlUtils;
    }

    private final void removePointsFromAttr(Element element, String attr) {
        String value = element.attr(attr).replaceAll("\\.", "");
        element.attr(attr, value);
    }
}

