/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.velocity.tool;

import com.google.common.base.Preconditions;
import org.apache.velocity.tools.config.DefaultKey;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@DefaultKey(value="htmlTool")
public final class HtmlTool {
    public final Element parse(String html) {
        Preconditions.checkNotNull((Object)html, (Object)"Received a null pointer as body");
        return Jsoup.parse((String)html).body();
    }

    public final void removeAttribute(Element root, String selector, String attribute) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)selector, (Object)"Received a null pointer as selector");
        Preconditions.checkNotNull((Object)attribute, (Object)"Received a null pointer as attribute");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.removeAttr(attribute);
        }
    }

    public final void removeClass(Element root, String selector, String className) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)selector, (Object)"Received a null pointer as selector");
        Preconditions.checkNotNull((Object)className, (Object)"Received a null pointer as className");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.removeClass(className);
            if (!element.classNames().isEmpty()) continue;
            element.removeAttr("class");
        }
    }

    public final void retag(Element root, String selector, String tag) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)selector, (Object)"Received a null pointer as selector");
        Preconditions.checkNotNull((Object)tag, (Object)"Received a null pointer as tag");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.tagName(tag);
        }
    }

    public final void swapTagWithParent(Element root, String selector) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)selector, (Object)"Received a null pointer as selector");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            Element parent = element.parent();
            String text = element.text();
            element.text("");
            parent.replaceWith((Node)element);
            element.appendChild((Node)parent);
            parent.text(text);
        }
    }

    public final void unwrap(Element root, String selector) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)selector, (Object)"Received a null pointer as selector");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.unwrap();
        }
    }

    public final void wrap(Element root, String selector, String wrapper) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)selector, (Object)"Received a null pointer as selector");
        Preconditions.checkNotNull((Object)wrapper, (Object)"Received a null pointer as HTML wrap");
        Elements elements = root.select(selector);
        for (Element element : elements) {
            element.wrap(wrapper);
        }
    }
}

