/*
 * Decompiled with CFR 0.152.
 */
package com.bernardomg.velocity.tool;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.tools.config.DefaultKey;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

@DefaultKey(value="siteTool")
public class SiteTool {
    private static final String ID_INVALID_REGEX = "[ _.]";

    public final void fixAnchorLinks(Element root) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        for (Element anchor : root.getElementsByTag("a")) {
            String ref = anchor.attr("href");
            if (ref.isEmpty() || !ref.substring(0, 1).equals("#")) continue;
            anchor.attr("href", ref.toLowerCase().replaceAll(ID_INVALID_REGEX, ""));
        }
    }

    public final void fixHeadingIds(Element root) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Elements headings = root.select("h1,h2,h3,h4,h5,h6");
        for (Element heading : headings) {
            String idText = heading.hasAttr("id") ? heading.attr("id") : heading.text();
            heading.attr("id", idText.toLowerCase().replaceAll(ID_INVALID_REGEX, ""));
        }
    }

    public final void fixReport(Element root, String report) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Preconditions.checkNotNull((Object)report, (Object)"Received a null pointer as report");
        switch (report) {
            case "plugins": {
                this.fixReportPlugins(root);
                break;
            }
            case "plugin-management": {
                this.fixReportPluginManagement(root);
                break;
            }
            case "changes-report": {
                this.fixReportChanges(root);
                break;
            }
            case "surefire-report": {
                this.fixReportSurefire(root);
                break;
            }
            case "failsafe-report": {
                this.fixReportFailsafe(root);
                break;
            }
            case "checkstyle": 
            case "checkstyle-aggregate": {
                this.fixReportCheckstyle(root);
                break;
            }
            case "findbugs": {
                this.fixReportFindbugs(root);
                break;
            }
            case "pmd": {
                this.fixReportPmd(root);
                break;
            }
            case "cpd": {
                this.fixReportCpd(root);
                break;
            }
            case "jdepend-report": {
                this.fixReportJdepend(root);
                break;
            }
            case "taglist": {
                this.fixReportTaglist(root);
                break;
            }
            case "dependencies": {
                this.fixReportDependencies(root);
                break;
            }
            case "project-summary": 
            case "summary": {
                this.fixReportProjectSummary(root);
                break;
            }
            case "license": 
            case "licenses": {
                this.fixReportLicense(root);
                break;
            }
            case "team-list": 
            case "team": {
                this.fixReportTeamList(root);
                break;
            }
            case "dependency-analysis": {
                this.fixReportDependencyAnalysis(root);
                break;
            }
        }
    }

    public final void transformIcons(Element root) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("img[src$=images/add.gif]", "<span><span class=\"fa fa-plus\" aria-hidden=\"true\"></span><span class=\"sr-only\">Addition</span></span>");
        replacements.put("img[src$=images/remove.gif]", "<span><span class=\"fa fa-minus\" aria-hidden=\"true\"></span><span class=\"sr-only\">Remove</span></span>");
        replacements.put("img[src$=images/fix.gif]", "<span><span class=\"fa fa-wrench\" aria-hidden=\"true\"></span><span class=\"sr-only\">Fix</span></span>");
        replacements.put("img[src$=images/update.gif]", "<span><span class=\"fa fa-refresh\" aria-hidden=\"true\"></span><span class=\"sr-only\">Refresh</span></span>");
        replacements.put("img[src$=images/icon_help_sml.gif]", "<span><span class=\"fa fa-question\" aria-hidden=\"true\"></span><span class=\"sr-only\">Question</span></span>");
        replacements.put("img[src$=images/icon_success_sml.gif]", "<span><span class=\"navbar-icon fa fa-check\" aria-hidden=\"true\" title=\"Passed\" aria-label=\"Passed\"></span><span class=\"sr-only\">Passed</span></span>");
        replacements.put("img[src$=images/icon_warning_sml.gif]", "<span><span class=\"fa fa-exclamation\" aria-hidden=\"true\"></span><span class=\"sr-only\">Warning</span>");
        replacements.put("img[src$=images/icon_error_sml.gif]", "<span><span class=\"navbar-icon fa fa-close\" aria-hidden=\"true\" title=\"Failed\" aria-label=\"Failed\"></span><span class=\"sr-only\">Failed</span></span>");
        replacements.put("img[src$=images/icon_info_sml.gif]", "<span><span class=\"fa fa-info\" aria-hidden=\"true\"></span><span class=\"sr-only\">Info</span></span>");
        this.replaceAll(root, replacements);
    }

    public final void transformImagesToFigures(Element root) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Elements images = root.select("section img");
        if (!images.isEmpty()) {
            for (Element img : images) {
                Element figure = new Element(Tag.valueOf((String)"figure"), "");
                img.replaceWith((Node)figure);
                figure.appendChild((Node)img);
                if (!img.hasAttr("alt")) continue;
                Element caption = new Element(Tag.valueOf((String)"figcaption"), "");
                caption.text(img.attr("alt"));
                figure.appendChild((Node)caption);
            }
        }
    }

    public final void transformTables(Element root) {
        Preconditions.checkNotNull((Object)root, (Object)"Received a null pointer as root element");
        Elements tables = root.select("table");
        for (Element table : tables) {
            table.addClass("table");
            table.addClass("table-striped");
            table.addClass("table-bordered");
        }
    }

    private final void fixReportChanges(Element root) {
        for (Element head : root.getElementsByTag("h2")) {
            head.tagName("h1");
        }
        Elements headings = root.getElementsByTag("h3");
        if (!headings.isEmpty()) {
            ((Element)headings.iterator().next()).tagName("h2");
        }
        for (Element heading : root.getElementsByTag("h3")) {
            heading.parent().attr("id", heading.id());
            heading.removeAttr("id");
            String text = heading.text();
            String[] texts = text.split("\u2013", 2);
            if (texts.length != 2) continue;
            Element timeElement = new Element(Tag.valueOf((String)"time"), "");
            timeElement.text(texts[1].trim());
            Element smallElement = new Element(Tag.valueOf((String)"small"), "");
            smallElement.append("(");
            smallElement.appendChild((Node)timeElement);
            smallElement.append(")");
            heading.text(texts[0]);
            heading.appendChild((Node)smallElement);
        }
        Elements sections = root.getElementsByTag("section");
        if (!sections.isEmpty()) {
            Element section = (Element)sections.iterator().next();
            for (Element child : section.children()) {
                child.remove();
                root.appendChild((Node)child);
            }
            section.remove();
        }
    }

    private final void fixReportCheckstyle(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            ((Element)elements.iterator().next()).tagName("h1");
        }
        root.select("img[src=\"images/rss.png\"]").remove();
    }

    private final void fixReportCpd(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            ((Element)elements.iterator().next()).tagName("h1");
        }
    }

    private final void fixReportDependencies(Element root) {
        root.prepend("<h1>Dependencies Report</h1>");
    }

    private final void fixReportDependencyAnalysis(Element root) {
        for (Element head : root.getElementsByTag("h2")) {
            head.tagName("h1");
        }
        for (Element head : root.getElementsByTag("h3")) {
            head.tagName("h2");
        }
    }

    private final void fixReportFailsafe(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            Element heading = (Element)elements.iterator().next();
            heading.tagName("h1");
            heading.text("Failsafe Report");
        }
    }

    private final void fixReportFindbugs(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            ((Element)elements.iterator().next()).tagName("h1");
        }
    }

    private final void fixReportJdepend(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            ((Element)elements.iterator().next()).tagName("h1");
        }
    }

    private final void fixReportLicense(Element root) {
        root.prepend("<h1>License</h1>");
    }

    private final void fixReportPluginManagement(Element root) {
        for (Element head : root.getElementsByTag("h2")) {
            head.tagName("h1");
        }
        Elements sections = root.getElementsByTag("section");
        if (!sections.isEmpty()) {
            Element section = (Element)sections.iterator().next();
            for (Element child : section.children()) {
                child.remove();
                root.appendChild((Node)child);
            }
            section.remove();
        }
    }

    private final void fixReportPlugins(Element root) {
        root.prepend("<h1>Plugins Report</h1>");
    }

    private final void fixReportPmd(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            ((Element)elements.iterator().next()).tagName("h1");
        }
    }

    private final void fixReportProjectSummary(Element root) {
        for (Element head : root.getElementsByTag("h2")) {
            head.tagName("h1");
        }
        for (Element head : root.getElementsByTag("h3")) {
            head.tagName("h2");
        }
    }

    private final void fixReportSurefire(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            ((Element)elements.iterator().next()).tagName("h1");
        }
    }

    private final void fixReportTaglist(Element root) {
        Elements elements = root.getElementsByTag("h2");
        if (!elements.isEmpty()) {
            ((Element)elements.iterator().next()).tagName("h1");
        }
    }

    private final void fixReportTeamList(Element root) {
        for (Element head : root.getElementsByTag("h2")) {
            head.tagName("h1");
        }
        for (Element head : root.getElementsByTag("h3")) {
            head.tagName("h2");
        }
    }

    private final void replaceAll(Element root, Map<String, String> replacements) {
        for (Map.Entry<String, String> replacementEntry : replacements.entrySet()) {
            Element replacementBody;
            String selector = replacementEntry.getKey();
            String replacement = replacementEntry.getValue();
            Elements elements = root.select(selector);
            if (elements.isEmpty() || (replacementBody = Jsoup.parse((String)replacement).body()).children().isEmpty()) continue;
            Element replacementElem = replacementBody.child(0);
            for (Element element : elements) {
                element.replaceWith((Node)replacementElem.clone());
            }
        }
    }
}

