/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiIterator<T>
implements Iterator<T> {
    private final List<Iterator<T>> iterators;
    private Iterator<T> current;
    private int nextIndex;

    public MultiIterator(List<Iterator<T>> iterators) {
        this.iterators = iterators;
        this.current = iterators.get(0);
        this.nextIndex = 1;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        if (this.nextIndex >= this.iterators.size()) {
            return false;
        }
        this.current = this.iterators.get(this.nextIndex);
        ++this.nextIndex;
        return this.hasNext();
    }

    @Override
    public T next() {
        if (this.current != null && this.current.hasNext()) {
            return this.current.next();
        }
        if (this.nextIndex >= this.iterators.size()) {
            throw new NoSuchElementException();
        }
        this.current = this.iterators.get(this.nextIndex);
        ++this.nextIndex;
        return this.next();
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.current.remove();
    }
}

