/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base.function;

import com.blazebit.persistence.integration.hibernate.base.function.CustomStandardSqlAstTranslator;
import com.blazebit.persistence.integration.hibernate.base.function.HibernateFunctionRenderContext;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class HibernateJpqlFunctionAdapter
extends AbstractSqmSelfRenderingFunctionDescriptor
implements FunctionRenderingSupport {
    private final JpqlFunction function;

    public HibernateJpqlFunctionAdapter(final SessionFactoryImplementor sfi, final JpqlFunction function) {
        super(null, null, new FunctionReturnTypeResolver(){

            public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
                Class argumentClass = null;
                if (arguments.isEmpty()) {
                    Class returnType = function.getReturnType(null);
                    return returnType == null ? null : typeConfiguration.getBasicTypeForJavaType(returnType);
                }
                SqmTypedNode<?> specifiedArgument = arguments.get(0);
                argumentClass = specifiedArgument.getNodeJavaType() == null ? null : specifiedArgument.getNodeJavaType().getJavaTypeClass();
                Class returnType = function.getReturnType(argumentClass);
                if (returnType == null) {
                    return null;
                }
                if (returnType == argumentClass) {
                    SqmExpressible nodeType = specifiedArgument.getNodeType();
                    if (nodeType instanceof PersistentAttribute) {
                        DomainType type = ((PersistentAttribute)nodeType).getValueGraphType();
                        if (type instanceof ReturnableType) {
                            return (ReturnableType)type;
                        }
                        return null;
                    }
                    return (ReturnableType)nodeType;
                }
                return typeConfiguration.getBasicTypeForJavaType(returnType);
            }

            public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
                SqlAstNode specifiedArgument = arguments.get(0);
                JdbcMappingContainer specifiedArgType = specifiedArgument instanceof Expression ? ((Expression)specifiedArgument).getExpressionType() : null;
                Class argumentClass = specifiedArgType instanceof BasicValuedMapping ? ((BasicValuedMapping)specifiedArgType).getExpressibleJavaType().getJavaTypeClass() : null;
                Class returnType = function.getReturnType(argumentClass);
                if (returnType == null) {
                    return null;
                }
                if (argumentClass == returnType) {
                    return (BasicValuedMapping)specifiedArgType;
                }
                return sfi.getTypeConfiguration().getBasicTypeForJavaType(returnType);
            }
        }, (FunctionArgumentTypeResolver)("com.blazebit.persistence.impl.function.entity.EntityFunction".equals(function.getClass().getName()) ? StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE : null));
        this.function = function;
    }

    public JpqlFunction unwrap() {
        return this.function;
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        AbstractSqlAstTranslator sqlAstTranslator = (AbstractSqlAstTranslator)walker;
        CustomStandardSqlAstTranslator customStandardSqlAstTranslator = new CustomStandardSqlAstTranslator(sqlAstTranslator.getSessionFactory());
        ArrayList<String> sqlArguments = new ArrayList<String>(sqlAstArguments.size());
        for (SqlAstNode sqlAstNode : sqlAstArguments) {
            customStandardSqlAstTranslator.getStringBuilder().setLength(0);
            sqlAstNode.accept(customStandardSqlAstTranslator);
            sqlArguments.add(customStandardSqlAstTranslator.getSql());
        }
        sqlAstTranslator.getParameterBinders().addAll(customStandardSqlAstTranslator.getParameterBinders());
        HibernateFunctionRenderContext context = new HibernateFunctionRenderContext(sqlArguments);
        this.function.render((FunctionRenderContext)context);
        sqlAppender.appendSql(context.renderToString());
    }
}

