/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.bmuschko.gradle.docker.shaded.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Network
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Scope")
    private String scope;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="EnableIPv6")
    private Boolean enableIPv6;
    @JsonProperty(value="Internal")
    private Boolean internal;
    @JsonProperty(value="IPAM")
    private Ipam ipam;
    @JsonProperty(value="Containers")
    private Map<String, ContainerNetworkConfig> containers;
    @JsonProperty(value="Options")
    private Map<String, String> options;
    @JsonProperty(value="Attachable")
    private Boolean attachable;
    @JsonProperty(value="Labels")
    public Map<String, String> labels;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public String getDriver() {
        return this.driver;
    }

    public Boolean getEnableIPv6() {
        return this.enableIPv6;
    }

    public Boolean getInternal() {
        return this.internal;
    }

    public Ipam getIpam() {
        return this.ipam;
    }

    public Map<String, ContainerNetworkConfig> getContainers() {
        return this.containers;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Boolean isAttachable() {
        return this.attachable;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Ipam {
        @JsonProperty(value="Driver")
        private String driver;
        @JsonProperty(value="Config")
        private List<Config> config = new ArrayList<Config>();
        @JsonProperty(value="Options")
        private Map<String, String> options = null;

        public String getDriver() {
            return this.driver;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public List<Config> getConfig() {
            return this.config;
        }

        public Ipam withConfig(List<Config> ipamConfigs) {
            this.config = ipamConfigs;
            return this;
        }

        public Ipam withConfig(Config ... ipamConfigs) {
            this.config = Arrays.asList(ipamConfigs);
            return this;
        }

        public Ipam withDriver(String driver) {
            this.driver = driver;
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Config {
            @JsonProperty(value="Subnet")
            private String subnet;
            @JsonProperty(value="IPRange")
            private String ipRange;
            @JsonProperty(value="Gateway")
            private String gateway;
            @JsonProperty(value="NetworkID")
            private String networkID;

            public String getSubnet() {
                return this.subnet;
            }

            public String getIpRange() {
                return this.ipRange;
            }

            public String getGateway() {
                return this.gateway;
            }

            public Config withSubnet(String subnet) {
                this.subnet = subnet;
                return this;
            }

            public Config withIpRange(String ipRange) {
                this.ipRange = ipRange;
                return this;
            }

            public Config withGateway(String gateway) {
                this.gateway = gateway;
                return this;
            }

            public String getNetworkID() {
                return this.networkID;
            }

            public void setNetworkID(String networkID) {
                this.networkID = networkID;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ContainerNetworkConfig {
        @JsonProperty(value="EndpointID")
        private String endpointId;
        @JsonProperty(value="MacAddress")
        private String macAddress;
        @JsonProperty(value="IPv4Address")
        private String ipv4Address;
        @JsonProperty(value="IPv6Address")
        private String ipv6Address;

        public String getEndpointId() {
            return this.endpointId;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public String getIpv4Address() {
            return this.ipv4Address;
        }

        public String getIpv6Address() {
            return this.ipv6Address;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }
}

