/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.bmuschko.gradle.docker.shaded.org.apache.commons.lang.StringUtils;
import com.github.dockerjava.core.exception.GoLangFileMatchException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GoLangFileMatch {
    public static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private static final String PATTERN_CHARS_TO_ESCAPE = "\\.[]{}()*+-?^$|";

    private GoLangFileMatch() {
    }

    public static boolean match(List<String> patterns, File file) {
        return !GoLangFileMatch.match(patterns, file.getPath()).isEmpty();
    }

    public static boolean match(String pattern, File file) {
        return GoLangFileMatch.match(pattern, file.getPath());
    }

    public static List<String> match(List<String> patterns, String name) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String pattern : patterns) {
            if (!GoLangFileMatch.match(pattern, name)) continue;
            matches.add(pattern);
        }
        return matches;
    }

    public static boolean match(String pattern, String name) {
        return GoLangFileMatch.buildPattern(pattern).matcher(name).matches();
    }

    private static Pattern buildPattern(String pattern) {
        StringBuilder patternStringBuilder = new StringBuilder("^");
        while (!pattern.isEmpty()) {
            if ((pattern = GoLangFileMatch.appendChunkPattern(patternStringBuilder, pattern)).isEmpty()) continue;
            patternStringBuilder.append(GoLangFileMatch.quote(File.separatorChar));
        }
        patternStringBuilder.append("(").append(GoLangFileMatch.quote(File.separatorChar)).append(".*").append(")?");
        return Pattern.compile(patternStringBuilder.toString());
    }

    private static String quote(char separatorChar) {
        if (StringUtils.contains(PATTERN_CHARS_TO_ESCAPE, separatorChar)) {
            return "\\" + separatorChar;
        }
        return String.valueOf(separatorChar);
    }

    private static String appendChunkPattern(StringBuilder patternStringBuilder, String pattern) {
        if (pattern.equals("**") || pattern.startsWith("**" + File.separator)) {
            patternStringBuilder.append("(").append("[^").append(GoLangFileMatch.quote(File.separatorChar)).append("]*").append("(").append(GoLangFileMatch.quote(File.separatorChar)).append("[^").append(GoLangFileMatch.quote(File.separatorChar)).append("]*").append(")*").append(")?");
            return pattern.substring(pattern.length() == 2 ? 2 : 3);
        }
        boolean inRange = false;
        int rangeFrom = 0;
        RangeParseState rangeParseState = RangeParseState.CHAR_EXPECTED;
        boolean isEsc = false;
        block9: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '/': {
                    if (!inRange) {
                        if (!IS_WINDOWS && !isEsc) {
                            return pattern.substring(i + 1);
                        }
                        patternStringBuilder.append(GoLangFileMatch.quote(c));
                    } else {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                    }
                    isEsc = false;
                    continue block9;
                }
                case '\\': {
                    if (!inRange) {
                        if (!IS_WINDOWS) {
                            if (isEsc) {
                                patternStringBuilder.append(GoLangFileMatch.quote(c));
                                isEsc = false;
                                continue block9;
                            }
                            isEsc = true;
                            continue block9;
                        }
                        return pattern.substring(i + 1);
                    }
                    if (IS_WINDOWS || isEsc) {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                        isEsc = false;
                        continue block9;
                    }
                    isEsc = true;
                    continue block9;
                }
                case '[': {
                    if (!isEsc) {
                        if (inRange) {
                            throw new GoLangFileMatchException("[ not expected, closing bracket ] not yet reached");
                        }
                        rangeFrom = i;
                        rangeParseState = RangeParseState.CHAR_EXPECTED;
                        inRange = true;
                    } else if (!inRange) {
                        patternStringBuilder.append(c);
                    } else {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                    }
                    isEsc = false;
                    continue block9;
                }
                case ']': {
                    if (!isEsc) {
                        if (!inRange) {
                            throw new GoLangFileMatchException("] is not expected, [ was not met");
                        }
                        if (rangeParseState == RangeParseState.CHAR_EXPECTED_AFTER_DASH) {
                            throw new GoLangFileMatchException("Character range not finished");
                        }
                        patternStringBuilder.append(pattern.substring(rangeFrom, i + 1));
                        inRange = false;
                    } else if (!inRange) {
                        patternStringBuilder.append(c);
                    } else {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                    }
                    isEsc = false;
                    continue block9;
                }
                case '*': {
                    if (!inRange) {
                        if (!isEsc) {
                            patternStringBuilder.append("[^").append(GoLangFileMatch.quote(File.separatorChar)).append("]*");
                        } else {
                            patternStringBuilder.append(GoLangFileMatch.quote(c));
                        }
                    } else {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                    }
                    isEsc = false;
                    continue block9;
                }
                case '?': {
                    if (!inRange) {
                        if (!isEsc) {
                            patternStringBuilder.append("[^").append(GoLangFileMatch.quote(File.separatorChar)).append("]");
                        } else {
                            patternStringBuilder.append(GoLangFileMatch.quote(c));
                        }
                    } else {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                    }
                    isEsc = false;
                    continue block9;
                }
                case '-': {
                    if (!inRange) {
                        patternStringBuilder.append(GoLangFileMatch.quote(c));
                    } else if (!isEsc) {
                        if (rangeParseState != RangeParseState.CHAR_OR_DASH_EXPECTED) {
                            throw new GoLangFileMatchException("- character not expected");
                        }
                        rangeParseState = RangeParseState.CHAR_EXPECTED_AFTER_DASH;
                    } else {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                    }
                    isEsc = false;
                    continue block9;
                }
                default: {
                    if (!inRange) {
                        patternStringBuilder.append(GoLangFileMatch.quote(c));
                    } else {
                        rangeParseState = GoLangFileMatch.nextStateAfterChar(rangeParseState);
                    }
                    isEsc = false;
                }
            }
        }
        if (isEsc) {
            throw new GoLangFileMatchException("Escaped character missing");
        }
        if (inRange) {
            throw new GoLangFileMatchException("Character range not finished");
        }
        return "";
    }

    private static RangeParseState nextStateAfterChar(RangeParseState currentState) {
        if (currentState == RangeParseState.CHAR_EXPECTED_AFTER_DASH) {
            return RangeParseState.CHAR_EXPECTED;
        }
        return RangeParseState.CHAR_OR_DASH_EXPECTED;
    }

    private static enum RangeParseState {
        CHAR_EXPECTED,
        CHAR_OR_DASH_EXPECTED,
        CHAR_EXPECTED_AFTER_DASH;

    }
}

