/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.bmuschko.gradle.docker.shaded.com.google.common.net.UrlEscapers;
import com.bmuschko.gradle.docker.shaded.javax.ws.rs.client.WebTarget;
import com.bmuschko.gradle.docker.shaded.javax.ws.rs.core.GenericType;
import com.github.dockerjava.api.command.ListSwarmNodesCmd;
import com.github.dockerjava.api.model.SwarmNode;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSwarmNodesCmdExec
extends AbstrSyncDockerCmdExec<ListSwarmNodesCmd, List<SwarmNode>>
implements ListSwarmNodesCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListSwarmNodesCmdExec.class);

    public ListSwarmNodesCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<SwarmNode> execute(ListSwarmNodesCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/nodes");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<SwarmNode> nodes = webTarget.request().accept("application/json").get(new GenericType<List<SwarmNode>>(){});
        LOGGER.trace("Response: {}", (Object)nodes);
        return nodes;
    }
}

