/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

import com.braintreegateway.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryString {
    private final StringBuilder builder;
    public static String DEFAULT_ENCODING = "UTF-8";

    public QueryString() {
        this.builder = new StringBuilder("");
    }

    public QueryString(String content) {
        this.builder = new StringBuilder(content);
    }

    public QueryString append(String key, Object value) {
        if (value == null) {
            return this;
        }
        if (value instanceof Request) {
            return this.appendRequest(key, (Request)value);
        }
        if (value instanceof Map) {
            return this.appendMap(key, (Map)value);
        }
        return this.appendString(key, value.toString());
    }

    public QueryString appendEncodedData(String alreadyEncodedData) {
        if (alreadyEncodedData != null && alreadyEncodedData.length() > 0) {
            this.builder.append('&');
            this.builder.append(alreadyEncodedData);
        }
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    public static String encodeParam(String key, String value) {
        String encodedKey = QueryString.encode(key);
        String encodedValue = QueryString.encode(value);
        return encodedKey + "=" + encodedValue;
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(DEFAULT_ENCODING + " encoding should always be available");
        }
    }

    protected QueryString appendString(String key, String value) {
        if (key != null && !key.equals("") && value != null) {
            if (this.builder.length() > 0) {
                this.builder.append("&");
            }
            this.builder.append(QueryString.encodeParam(key, value));
        }
        return this;
    }

    protected QueryString appendRequest(String parent, Request request) {
        String requestQueryString;
        if (request != null && (requestQueryString = request.toQueryString(parent)).length() > 0) {
            if (this.builder.length() > 0) {
                this.builder.append("&");
            }
            this.builder.append(requestQueryString);
        }
        return this;
    }

    protected QueryString appendMap(String key, Map<?, ?> value) {
        for (Object keyString : value.keySet()) {
            this.appendString(String.format("%s[%s]", key, keyString), value.get(keyString).toString());
        }
        return this;
    }
}

