/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast;

import com.hazelcast.map.EntryProcessor;
import io.github.bucket4j.distributed.remote.AbstractBinaryTransaction;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.grid.hazelcast.SimpleBackupProcessor;
import io.github.bucket4j.util.ComparableByContent;
import java.util.Arrays;
import java.util.Map;

public class HazelcastEntryProcessor<K, T>
implements EntryProcessor<K, byte[], byte[]>,
ComparableByContent<HazelcastEntryProcessor> {
    private static final long serialVersionUID = 1L;
    private final byte[] requestBytes;
    private EntryProcessor<K, byte[], byte[]> backupProcessor;

    public HazelcastEntryProcessor(Request<T> request) {
        this.requestBytes = InternalSerializationHelper.serializeRequest(request);
    }

    public HazelcastEntryProcessor(byte[] requestBytes) {
        this.requestBytes = requestBytes;
    }

    public byte[] process(final Map.Entry<K, byte[]> entry) {
        return new AbstractBinaryTransaction(this.requestBytes){

            public boolean exists() {
                return entry.getValue() != null;
            }

            protected byte[] getRawState() {
                return (byte[])entry.getValue();
            }

            protected void setRawState(byte[] stateBytes) {
                entry.setValue(stateBytes);
                HazelcastEntryProcessor.this.backupProcessor = new SimpleBackupProcessor(stateBytes);
            }
        }.execute();
    }

    public EntryProcessor<K, byte[], byte[]> getBackupProcessor() {
        return this.backupProcessor;
    }

    public byte[] getRequestBytes() {
        return this.requestBytes;
    }

    public boolean equalsByContent(HazelcastEntryProcessor other) {
        return Arrays.equals(this.requestBytes, other.requestBytes);
    }
}

