/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.baseline;

import com.buschmais.jqassistant.core.analysis.api.baseline.Baseline;
import com.buschmais.jqassistant.core.shared.xml.JAXBHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import org.jqassistant.schema.baseline.v2.ColumnType;
import org.jqassistant.schema.baseline.v2.JqassistantBaseline;
import org.jqassistant.schema.baseline.v2.RowType;
import org.jqassistant.schema.baseline.v2.RuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaselineRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaselineRepository.class);
    private static final JAXBHelper<JqassistantBaseline> JAXB_HELPER = new JAXBHelper(JqassistantBaseline.class);
    private final File baselineFile;

    public BaselineRepository(com.buschmais.jqassistant.core.analysis.api.configuration.Baseline configuration, File ruleDirectory) {
        this.baselineFile = configuration.file().map(File::new).orElse(new File(ruleDirectory, "jqassistant-baseline.xml"));
    }

    public Optional<Baseline> read() {
        if (this.baselineFile.exists()) {
            log.info("Reading baseline from file '{}'.", (Object)this.baselineFile);
            return Optional.of(BaselineRepository.read(this.baselineFile));
        }
        log.info("Baseline file '{}' does not exist yet.", (Object)this.baselineFile);
        return Optional.empty();
    }

    public void write(Baseline baseline) {
        log.info("Writing baseline to file '{}'.", (Object)this.baselineFile);
        BaselineRepository.write(baseline, this.baselineFile);
    }

    private static Baseline read(File baselineFile) {
        try {
            return BaselineRepository.toBaseline((JqassistantBaseline)JAXB_HELPER.unmarshal(baselineFile.toURI().toURL()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read baseline file " + String.valueOf(baselineFile), e);
        }
    }

    private static Baseline toBaseline(JqassistantBaseline jqassistantBaseline) {
        Baseline baseline = new Baseline();
        BaselineRepository.toRuleBaselines(jqassistantBaseline.getConstraint(), baseline.getConstraints());
        BaselineRepository.toRuleBaselines(jqassistantBaseline.getConcept(), baseline.getConcepts());
        return baseline;
    }

    private static void toRuleBaselines(List<RuleType> ruleTypes, SortedMap<String, Baseline.RuleBaseline> ruleBaselines) {
        for (RuleType ruleType : ruleTypes) {
            Baseline.RuleBaseline ruleBaseline = new Baseline.RuleBaseline();
            for (RowType rowType : ruleType.getRow()) {
                TreeMap<String, String> columns = new TreeMap<String, String>();
                for (ColumnType columnType : rowType.getColumn()) {
                    columns.put(columnType.getName(), columnType.getValue());
                }
                ruleBaseline.getRows().put(rowType.getKey(), columns);
            }
            ruleBaselines.put(ruleType.getId(), ruleBaseline);
        }
    }

    private static void write(Baseline baseline, File baselinefile) {
        JqassistantBaseline jqassistantBaseline = BaselineRepository.fromBaseline(baseline);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(baselinefile));){
            JAXB_HELPER.marshal((Object)jqassistantBaseline, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write baseline file " + String.valueOf(baselinefile), e);
        }
    }

    private static JqassistantBaseline fromBaseline(Baseline baseline) {
        JqassistantBaseline jqassistantBaseline = new JqassistantBaseline();
        BaselineRepository.fromRuleBaselines(baseline.getConstraints(), jqassistantBaseline.getConstraint());
        BaselineRepository.fromRuleBaselines(baseline.getConcepts(), jqassistantBaseline.getConcept());
        return jqassistantBaseline;
    }

    private static void fromRuleBaselines(SortedMap<String, Baseline.RuleBaseline> ruleBaselines, List<RuleType> ruleTypes) {
        for (Map.Entry<String, Baseline.RuleBaseline> ruleBaselineEntry : ruleBaselines.entrySet()) {
            String ruleId = ruleBaselineEntry.getKey();
            Baseline.RuleBaseline ruleBaseline = ruleBaselineEntry.getValue();
            RuleType ruleType = new RuleType();
            ruleType.setId(ruleId);
            for (Map.Entry<String, SortedMap<String, String>> rowEntry : ruleBaseline.getRows().entrySet()) {
                String rowKey = rowEntry.getKey();
                SortedMap<String, String> columns = rowEntry.getValue();
                RowType rowType = new RowType();
                rowType.setKey(rowKey);
                for (Map.Entry<String, String> columnEntry : columns.entrySet()) {
                    ColumnType columnType = new ColumnType();
                    columnType.setName(columnEntry.getKey());
                    columnType.setValue(columnEntry.getValue());
                    rowType.getColumn().add(columnType);
                }
                ruleType.getRow().add(rowType);
            }
            ruleTypes.add(ruleType);
        }
    }
}

