/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.configuration;

import com.buschmais.jqassistant.core.analysis.api.configuration.Baseline;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.shared.annotation.Description;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="jqassistant.analyze")
public interface Analyze {
    public static final String CONCEPTS = "concepts";
    public static final String CONSTRAINTS = "constraints";
    public static final String EXCLUDE_CONSTRAINTS = "exclude-constraints";
    public static final String GROUPS = "groups";
    public static final String RULE_PARAMETERS = "rule-parameters";
    public static final String EXECUTE_APPLIED_CONCEPTS = "execute-applied-concepts";
    public static final String WARN_ON_EXECUTION_TIME_SECONDS = "warn-on-rule-execution-time-seconds";

    @Description(value="The rule configuration.")
    public Rule rule();

    @Description(value="The baseline configuration.")
    public Baseline baseline();

    @Description(value="The report configuration.")
    public Report report();

    @Description(value="The concepts to be applied.")
    public Optional<List<String>> concepts();

    @Description(value="The constraints to be validated.")
    public Optional<List<String>> constraints();

    @Description(value="The constraints to be excluded.")
    public Optional<List<String>> excludeConstraints();

    @Description(value="The groups to be executed.")
    public Optional<List<String>> groups();

    @Description(value="The parameters to be passed to rules.")
    public Map<String, String> ruleParameters();

    @Description(value="Execute concepts even if they have already been applied before.")
    @WithDefault(value="false")
    public boolean executeAppliedConcepts();

    @Description(value="The execution time [seconds] for rules (concepts/constraints) to show a warning. Can be used as a hint for optimization.")
    @WithDefault(value="5")
    public int warnOnExecutionTimeSeconds();
}

