/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.Analyzer;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineManager;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerContextImpl;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerRuleVisitor;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.rule.api.executor.RuleSetExecutor;
import com.buschmais.jqassistant.core.rule.api.executor.RuleVisitor;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.store.api.Store;
import java.util.Collection;
import java.util.Map;

public class AnalyzerImpl
implements Analyzer {
    private final Analyze configuration;
    private final ClassLoader classLoader;
    private final Store store;
    private final Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins;
    private final BaselineManager baselineManager;
    private final ReportPlugin reportPlugin;

    public AnalyzerImpl(Analyze configuration, ClassLoader classLoader, Store store, Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins, BaselineManager baselineManager, ReportPlugin reportPlugin) {
        this.configuration = configuration;
        this.classLoader = classLoader;
        this.store = store;
        this.ruleInterpreterPlugins = ruleInterpreterPlugins;
        this.baselineManager = baselineManager;
        this.reportPlugin = reportPlugin;
    }

    @Override
    public void execute(RuleSet ruleSet, RuleSelection ruleSelection) throws RuleException {
        AnalyzerContextImpl analyzerContext = new AnalyzerContextImpl(this.configuration, this.classLoader, this.store, this.baselineManager);
        this.baselineManager.start();
        AnalyzerRuleVisitor visitor = new AnalyzerRuleVisitor(this.configuration, analyzerContext, this.ruleInterpreterPlugins, this.reportPlugin);
        RuleSetExecutor executor = new RuleSetExecutor((RuleVisitor)visitor, this.configuration.rule());
        executor.execute(ruleSet, ruleSelection);
        this.baselineManager.stop();
    }
}

