/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.neo4j.embedded.impl;

import com.buschmais.jqassistant.neo4j.embedded.EmbeddedNeo4jServer;
import com.buschmais.jqassistant.neo4j.embedded.impl.TkClasspathResource;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.takes.Take;
import org.takes.facets.fork.FkRegex;
import org.takes.facets.fork.Fork;
import org.takes.facets.fork.TkFork;
import org.takes.http.FtBasic;

class Neo4jCommunityNeoServer
implements EmbeddedNeo4jServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Neo4jCommunityNeoServer.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jCommunityNeoServer.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private Integer httpPort;
    private ClassLoader classLoader;
    private String url;

    Neo4jCommunityNeoServer() {
    }

    @Override
    public void initialize(String listenAddress, Integer httpPort, Integer boltPort, ClassLoader classLoader) {
        this.httpPort = httpPort;
        this.classLoader = classLoader;
        this.url = String.format("http://%s:%d?dbms=bolt://%s:%d&preselectAuthMethod=NO_AUTH", listenAddress, httpPort, listenAddress, boltPort);
    }

    @Override
    public void start() {
        this.executorService.submit(() -> {
            LOGGER.info("Starting HTTP server.");
            try {
                FtBasic front = new FtBasic((Take)new TkFork(new Fork[]{new FkRegex(".+", (Take)new TkClasspathResource(this.classLoader))}), this.httpPort.intValue());
                front.start(this.ready::get);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot start HTTP server.", e);
            }
            LOGGER.info("Stopped HTTP server.");
        });
        LOGGER.info("Neo4j browser available at {}.", (Object)this.url);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping HTTP server.");
        this.ready.set(true);
        this.executorService.shutdown();
    }

    @Override
    public void openBrowser() {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            log.info("Opening browser.");
            try {
                Desktop.getDesktop().browse(new URI(this.url));
            }
            catch (IOException | URISyntaxException e) {
                log.warn("Cannot open browser for URL {}", (Object)this.url, (Object)e);
            }
        }
    }
}

