/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.neo4j.embedded.impl;

import com.buschmais.jqassistant.neo4j.embedded.EmbeddedNeo4jServer;
import com.buschmais.jqassistant.neo4j.embedded.EmbeddedNeo4jServerFactory;
import com.buschmais.jqassistant.neo4j.embedded.impl.Neo4jCommunityNeoServer;
import com.buschmais.xo.neo4j.embedded.api.EmbeddedNeo4jXOProvider;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.io.ByteUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jCommunityServerFactory
implements EmbeddedNeo4jServerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Neo4jCommunityServerFactory.class);

    @Override
    public EmbeddedNeo4jServer getServer() {
        return new Neo4jCommunityNeoServer();
    }

    @Override
    public Properties getProperties(boolean connectorEnabled, String listenAddress, Integer boltPort, Map<String, String> neo4jProperties, List<File> plugins) {
        EmbeddedNeo4jXOProvider.PropertiesBuilder propertiesBuilder = EmbeddedNeo4jXOProvider.propertiesBuilder().property(GraphDatabaseSettings.procedure_unrestricted, List.of("*")).property(GraphDatabaseSettings.keep_logical_logs, (Object)Boolean.FALSE.toString()).property(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.mebiBytes((long)25L)).property(GraphDatabaseSettings.log_queries, (Object)GraphDatabaseSettings.LogQueryLevel.OFF).property(GraphDatabaseInternalSettings.dump_diagnostics, (Object)false).property(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period, (Object)0);
        if (connectorEnabled) {
            propertiesBuilder.property(BoltConnector.enabled, (Object)true);
            propertiesBuilder.property(BoltConnector.listen_address, (Object)new SocketAddress(listenAddress, boltPort.intValue()));
        }
        neo4jProperties.forEach((arg_0, arg_1) -> ((EmbeddedNeo4jXOProvider.PropertiesBuilder)propertiesBuilder).property(arg_0, arg_1));
        propertiesBuilder.property("server.logs.debug.enabled", (Object)Boolean.FALSE.toString());
        propertiesBuilder.property("dbms.usage_report.enabled", (Object)Boolean.FALSE.toString());
        Properties properties = propertiesBuilder.build();
        if (!plugins.isEmpty()) {
            properties.setProperty("xo.neo4j.embedded.plugins", plugins.stream().map(File::getAbsolutePath).collect(Collectors.joining(",")));
        }
        return properties;
    }
}

