/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.neo4j.embedded.impl;

import java.io.InputStream;
import java.net.URLConnection;
import lombok.Generated;
import org.takes.HttpException;
import org.takes.Response;
import org.takes.rq.RqHref;
import org.takes.rs.RsWithBody;
import org.takes.rs.RsWithHeader;
import org.takes.tk.TkWrap;

final class TkClasspathResource
extends TkWrap {
    public static final String STATIC_CONTENT_PREFIX = "/jqassistant";

    public TkClasspathResource(ClassLoader classLoader) {
        super(request -> {
            String path = new RqHref.Base(request).href().path();
            String resource = TkClasspathResource.resolve(path);
            InputStream inputStream = classLoader.getResourceAsStream(resource);
            if (inputStream == null) {
                throw new HttpException(404, String.format("%s not found.", resource));
            }
            return new RsWithHeader((Response)new RsWithBody(inputStream), (CharSequence)"content-type", (CharSequence)URLConnection.guessContentTypeFromName(path));
        });
    }

    static String resolve(String path) {
        if (path.endsWith("/")) {
            return TkClasspathResource.resolve(path + "index.html");
        }
        if (path.startsWith(STATIC_CONTENT_PREFIX)) {
            return TkClasspathResource.resolve("META-INF/jqassistant-static-content", path.substring(STATIC_CONTENT_PREFIX.length()));
        }
        return TkClasspathResource.resolve("browser", path);
    }

    private static String resolve(String prefix, String path) {
        return String.format("%s%s", prefix, path);
    }

    @Generated
    public String toString() {
        return "TkClasspathResource(super=" + super.toString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkClasspathResource)) {
            return false;
        }
        TkClasspathResource other = (TkClasspathResource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TkClasspathResource;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

