/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.executor;

import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.executor.RuleVisitor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.model.SeverityRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSetExecutor<R> {
    private static final Logger log = LoggerFactory.getLogger(RuleSetExecutor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSetExecutor.class);
    private final Map<Concept, R> executedConcepts = new HashMap<Concept, R>();
    private final Set<Constraint> executedConstraints = new LinkedHashSet<Constraint>();
    private final Set<Group> executedGroups = new LinkedHashSet<Group>();
    private final RuleVisitor<R> ruleVisitor;
    private final Rule configuration;

    public RuleSetExecutor(RuleVisitor<R> ruleVisitor, Rule configuration) {
        this.ruleVisitor = ruleVisitor;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RuleSet ruleSet, RuleSelection ruleSelection) throws RuleException {
        this.ruleVisitor.beforeRules();
        try {
            for (String conceptPattern : ruleSelection.getConceptIds()) {
                this.applyConcepts(ruleSet, conceptPattern, null, null);
            }
            for (String groupPattern : ruleSelection.getGroupIds()) {
                this.executeGroups(ruleSet, groupPattern, null, null);
            }
            for (String constraintPattern : ruleSelection.getConstraintIds()) {
                this.validateConstraints(ruleSet, constraintPattern, null, null);
            }
        }
        finally {
            this.ruleVisitor.afterRules();
        }
    }

    private void executeGroup(RuleSet ruleSet, Group group, Severity parentSeverity) throws RuleException {
        if (!this.executedGroups.contains(group)) {
            this.ruleVisitor.beforeGroup(group, this.getEffectiveSeverity(group, parentSeverity, parentSeverity));
            for (Map.Entry<String, Severity> conceptEntry : group.getConcepts().entrySet()) {
                this.applyConcepts(ruleSet, conceptEntry.getKey(), parentSeverity, conceptEntry.getValue());
            }
            for (Map.Entry<String, Severity> groupEntry : group.getGroups().entrySet()) {
                this.executeGroups(ruleSet, groupEntry.getKey(), parentSeverity, groupEntry.getValue());
            }
            Map<String, Severity> constraints = group.getConstraints();
            for (Map.Entry<String, Severity> constraintEntry : constraints.entrySet()) {
                this.validateConstraints(ruleSet, constraintEntry.getKey(), parentSeverity, constraintEntry.getValue());
            }
            this.ruleVisitor.afterGroup(group);
            this.executedGroups.add(group);
        }
    }

    private void applyConcepts(RuleSet ruleSet, String conceptPattern, Severity parentSeverity, Severity requestedSeverity) throws RuleException {
        List matchingConcepts = ruleSet.getConceptBucket().match(conceptPattern);
        if (matchingConcepts.isEmpty()) {
            LOGGER.warn("Could not find concepts matching to '{}'.", (Object)conceptPattern);
        } else {
            for (Concept matchingConcept : matchingConcepts) {
                this.applyConcept(ruleSet, matchingConcept, parentSeverity, requestedSeverity, new LinkedHashSet<Concept>());
            }
        }
    }

    private void executeGroups(RuleSet ruleSet, String groupPattern, Severity parentSeverity, Severity requestedSeverity) throws RuleException {
        List matchingGroups = ruleSet.getGroupsBucket().match(groupPattern);
        if (matchingGroups.isEmpty()) {
            LOGGER.warn("Could not find groups matching to '{}'.", (Object)groupPattern);
        } else {
            for (Group matchingGroup : matchingGroups) {
                this.executeGroup(ruleSet, matchingGroup, this.getEffectiveSeverity(matchingGroup, parentSeverity, requestedSeverity));
            }
        }
    }

    private void validateConstraints(RuleSet ruleSet, String constraintPattern, Severity parentSeverity, Severity requestedSeverity) throws RuleException {
        List matchingConstraints = ruleSet.getConstraintBucket().match(constraintPattern);
        if (matchingConstraints.isEmpty()) {
            LOGGER.warn("Could not find constraints matching to '{}'.", (Object)constraintPattern);
        } else {
            for (Constraint matchingConstraint : matchingConstraints) {
                this.validateConstraint(ruleSet, matchingConstraint, parentSeverity, requestedSeverity);
            }
        }
    }

    private Severity getEffectiveSeverity(SeverityRule rule, Severity parentSeverity, Severity includeSeverity) {
        Severity inheritedSeverity = includeSeverity != null ? includeSeverity : parentSeverity;
        return inheritedSeverity != null ? inheritedSeverity : rule.getSeverity();
    }

    private void validateConstraint(RuleSet ruleSet, Constraint constraint, Severity groupSeverity, Severity includeSeverity) throws RuleException {
        if (!this.executedConstraints.contains(constraint)) {
            Severity effectiveSeverity = this.getEffectiveSeverity(constraint, groupSeverity, includeSeverity);
            if (this.applyRequiredConcepts(ruleSet, constraint, new LinkedHashSet<Concept>())) {
                this.checkDeprecation(constraint);
                this.ruleVisitor.visitConstraint(constraint, effectiveSeverity);
            } else {
                this.ruleVisitor.skipConstraint(constraint, effectiveSeverity);
            }
            this.executedConstraints.add(constraint);
        }
    }

    private R applyConcept(RuleSet ruleSet, Concept concept, Severity groupSeverity, Severity includeSeverity, Set<Concept> executionStack) throws RuleException {
        R result = this.executedConcepts.get(concept);
        if (result == null) {
            executionStack.add(concept);
            Severity effectiveSeverity = this.getEffectiveSeverity(concept, groupSeverity, includeSeverity);
            if (this.applyRequiredConcepts(ruleSet, concept, executionStack)) {
                Map<Concept, R> providedConceptResults = this.applyProvidedConcepts(ruleSet, concept, executionStack);
                this.checkDeprecation(concept);
                result = this.ruleVisitor.visitConcept(concept, effectiveSeverity, providedConceptResults);
            } else {
                this.ruleVisitor.skipConcept(concept, effectiveSeverity);
            }
            executionStack.remove(concept);
            this.executedConcepts.put(concept, result);
        }
        return result;
    }

    private Map<Concept, R> applyProvidedConcepts(RuleSet ruleSet, Concept concept, Set<Concept> stack) throws RuleException {
        LinkedHashMap<Concept, R> results = new LinkedHashMap<Concept, R>();
        for (String providingConceptId : ruleSet.getProvidedConcepts().getOrDefault(concept.getId(), Collections.emptySet())) {
            Concept providingConcept = (Concept)ruleSet.getConceptBucket().getById(providingConceptId);
            R result = this.applyConcept(ruleSet, providingConcept, null, null, stack);
            results.put(providingConcept, result);
        }
        return results;
    }

    private boolean applyRequiredConcepts(RuleSet ruleSet, ExecutableRule<?> rule, Set<Concept> stack) throws RuleException {
        boolean requiredConceptsApplied = true;
        for (Map.Entry<String, Boolean> entry : rule.getRequiresConcepts().entrySet()) {
            List requiredConcepts = ruleSet.getConceptBucket().match(entry.getKey());
            for (Concept requiredConcept : requiredConcepts) {
                if (stack.contains(requiredConcept)) continue;
                R conceptResult = this.applyConcept(ruleSet, requiredConcept, null, null, stack);
                Boolean optional = entry.getValue();
                if (optional == null) {
                    optional = this.configuration.requiredConceptsAreOptionalByDefault();
                }
                requiredConceptsApplied = this.ruleVisitor.isSuccess(conceptResult) || optional != false;
            }
        }
        return requiredConceptsApplied;
    }

    private void checkDeprecation(ExecutableRule<?> executableRule) {
        String deprecation = executableRule.getDeprecation();
        if (deprecation != null) {
            log.warn("Rule '{}' is deprecated: {} ({})", new Object[]{executableRule.getId(), executableRule.getDeprecation(), executableRule.getSource().getId()});
        }
    }
}

