/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RuleSelection {
    private static final String GROUP_DEFAULT = "default";
    private Set<String> conceptIds;
    private Set<String> constraintIds;
    private Set<String> groupIds;

    public static RuleSelection select(RuleSet ruleSet, Optional<List<String>> groupIds, Optional<List<String>> constraintIds, Optional<List<String>> conceptIds) {
        return RuleSelection.select(ruleSet, groupIds.orElse(Collections.emptyList()), constraintIds.orElse(Collections.emptyList()), conceptIds.orElse(Collections.emptyList()));
    }

    private static RuleSelection select(RuleSet ruleSet, List<String> groupIds, List<String> constraintIds, List<String> conceptIds) {
        if (groupIds.isEmpty() && conceptIds.isEmpty() && constraintIds.isEmpty() && ruleSet.getGroupsBucket().getIds().contains(GROUP_DEFAULT)) {
            return RuleSelection.builder().groupId(GROUP_DEFAULT).build();
        }
        return RuleSelection.builder().groupIds(new LinkedHashSet<String>(groupIds)).constraintIds(new LinkedHashSet<String>(constraintIds)).conceptIds(new LinkedHashSet<String>(conceptIds)).build();
    }

    public static RuleSelectionBuilder builder() {
        return new RuleSelectionBuilder();
    }

    public Set<String> getConceptIds() {
        return this.conceptIds;
    }

    public Set<String> getConstraintIds() {
        return this.constraintIds;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public String toString() {
        return "RuleSelection(conceptIds=" + this.getConceptIds() + ", constraintIds=" + this.getConstraintIds() + ", groupIds=" + this.getGroupIds() + ")";
    }

    private RuleSelection(Set<String> conceptIds, Set<String> constraintIds, Set<String> groupIds) {
        this.conceptIds = conceptIds;
        this.constraintIds = constraintIds;
        this.groupIds = groupIds;
    }

    public static class RuleSelectionBuilder {
        private ArrayList<String> conceptIds;
        private ArrayList<String> constraintIds;
        private ArrayList<String> groupIds;

        RuleSelectionBuilder() {
        }

        public RuleSelectionBuilder conceptId(String conceptId) {
            if (this.conceptIds == null) {
                this.conceptIds = new ArrayList();
            }
            this.conceptIds.add(conceptId);
            return this;
        }

        public RuleSelectionBuilder conceptIds(Collection<? extends String> conceptIds) {
            if (conceptIds == null) {
                throw new NullPointerException("conceptIds cannot be null");
            }
            if (this.conceptIds == null) {
                this.conceptIds = new ArrayList();
            }
            this.conceptIds.addAll(conceptIds);
            return this;
        }

        public RuleSelectionBuilder clearConceptIds() {
            if (this.conceptIds != null) {
                this.conceptIds.clear();
            }
            return this;
        }

        public RuleSelectionBuilder constraintId(String constraintId) {
            if (this.constraintIds == null) {
                this.constraintIds = new ArrayList();
            }
            this.constraintIds.add(constraintId);
            return this;
        }

        public RuleSelectionBuilder constraintIds(Collection<? extends String> constraintIds) {
            if (constraintIds == null) {
                throw new NullPointerException("constraintIds cannot be null");
            }
            if (this.constraintIds == null) {
                this.constraintIds = new ArrayList();
            }
            this.constraintIds.addAll(constraintIds);
            return this;
        }

        public RuleSelectionBuilder clearConstraintIds() {
            if (this.constraintIds != null) {
                this.constraintIds.clear();
            }
            return this;
        }

        public RuleSelectionBuilder groupId(String groupId) {
            if (this.groupIds == null) {
                this.groupIds = new ArrayList();
            }
            this.groupIds.add(groupId);
            return this;
        }

        public RuleSelectionBuilder groupIds(Collection<? extends String> groupIds) {
            if (groupIds == null) {
                throw new NullPointerException("groupIds cannot be null");
            }
            if (this.groupIds == null) {
                this.groupIds = new ArrayList();
            }
            this.groupIds.addAll(groupIds);
            return this;
        }

        public RuleSelectionBuilder clearGroupIds() {
            if (this.groupIds != null) {
                this.groupIds.clear();
            }
            return this;
        }

        public RuleSelection build() {
            Set<String> groupIds;
            Set<Object> constraintIds;
            Set<Object> conceptIds;
            switch (this.conceptIds == null ? 0 : this.conceptIds.size()) {
                case 0: {
                    conceptIds = Collections.emptySet();
                    break;
                }
                case 1: {
                    conceptIds = Collections.singleton(this.conceptIds.get(0));
                    break;
                }
                default: {
                    conceptIds = new LinkedHashSet(this.conceptIds.size() < 0x40000000 ? 1 + this.conceptIds.size() + (this.conceptIds.size() - 3) / 3 : Integer.MAX_VALUE);
                    conceptIds.addAll(this.conceptIds);
                    conceptIds = Collections.unmodifiableSet(conceptIds);
                }
            }
            switch (this.constraintIds == null ? 0 : this.constraintIds.size()) {
                case 0: {
                    constraintIds = Collections.emptySet();
                    break;
                }
                case 1: {
                    constraintIds = Collections.singleton(this.constraintIds.get(0));
                    break;
                }
                default: {
                    constraintIds = new LinkedHashSet(this.constraintIds.size() < 0x40000000 ? 1 + this.constraintIds.size() + (this.constraintIds.size() - 3) / 3 : Integer.MAX_VALUE);
                    constraintIds.addAll(this.constraintIds);
                    constraintIds = Collections.unmodifiableSet(constraintIds);
                }
            }
            switch (this.groupIds == null ? 0 : this.groupIds.size()) {
                case 0: {
                    groupIds = Collections.emptySet();
                    break;
                }
                case 1: {
                    groupIds = Collections.singleton(this.groupIds.get(0));
                    break;
                }
                default: {
                    groupIds = new LinkedHashSet(this.groupIds.size() < 0x40000000 ? 1 + this.groupIds.size() + (this.groupIds.size() - 3) / 3 : Integer.MAX_VALUE);
                    groupIds.addAll(this.groupIds);
                    groupIds = Collections.unmodifiableSet(groupIds);
                }
            }
            return new RuleSelection(conceptIds, constraintIds, groupIds);
        }

        public String toString() {
            return "RuleSelection.RuleSelectionBuilder(conceptIds=" + this.conceptIds + ", constraintIds=" + this.constraintIds + ", groupIds=" + this.groupIds + ")";
        }
    }
}

