/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.ConceptBucket;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ConstraintBucket;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.GroupsBucket;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RuleSetBuilder {
    private final DefaultRuleSet ruleSet = new DefaultRuleSet();

    private RuleSetBuilder() {
    }

    public static RuleSetBuilder newInstance() {
        return new RuleSetBuilder();
    }

    public RuleSetBuilder addConcept(Concept concept) throws RuleException {
        this.ruleSet.conceptBucket.add(concept);
        String providingConceptId = concept.getId();
        for (String providesConceptId : concept.getProvidedConcepts()) {
            this.ruleSet.providedConcepts.computeIfAbsent(providesConceptId, id -> new LinkedHashSet()).add(providingConceptId);
        }
        return this;
    }

    public RuleSetBuilder addConstraint(Constraint constraint) throws RuleException {
        this.ruleSet.constraintBucket.add(constraint);
        return this;
    }

    public RuleSetBuilder addGroup(Group group) throws RuleException {
        this.ruleSet.groupsBucket.add(group);
        for (Map.Entry<String, Set<String>> entry : group.getProvidedConcepts().entrySet()) {
            this.ruleSet.providedConcepts.computeIfAbsent(entry.getKey(), id -> new LinkedHashSet()).addAll((Collection)entry.getValue());
        }
        return this;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    private static class DefaultRuleSet
    implements RuleSet {
        private final ConceptBucket conceptBucket = new ConceptBucket();
        private final Map<String, Set<String>> providedConcepts = new HashMap<String, Set<String>>();
        private final ConstraintBucket constraintBucket = new ConstraintBucket();
        private final GroupsBucket groupsBucket = new GroupsBucket();

        private DefaultRuleSet() {
        }

        @Override
        public ConceptBucket getConceptBucket() {
            return this.conceptBucket;
        }

        @Override
        public Map<String, Set<String>> getProvidedConcepts() {
            return this.providedConcepts;
        }

        @Override
        public ConstraintBucket getConstraintBucket() {
            return this.constraintBucket;
        }

        @Override
        public GroupsBucket getGroupsBucket() {
            return this.groupsBucket;
        }

        public String toString() {
            return "RuleSetBuilder.DefaultRuleSet(conceptBucket=" + this.getConceptBucket() + ", providedConcepts=" + this.getProvidedConcepts() + ", constraintBucket=" + this.getConstraintBucket() + ", groupsBucket=" + this.getGroupsBucket() + ")";
        }
    }
}

