/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.shared.annotation.ToBeRemovedInVersion;
import java.util.EnumSet;
import java.util.Optional;

public enum Severity {
    BLOCKER("blocker", 0),
    CRITICAL("critical", 1),
    MAJOR("major", 2),
    MINOR("minor", 3),
    INFO("info", 4);

    private final String value;
    private final Integer level;

    private Severity(String value, Integer level) {
        this.value = value;
        this.level = level;
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated
    @ToBeRemovedInVersion(major=1, minor=13)
    public Integer getLevel() {
        return this.level;
    }

    public String getInfo(Severity fromSeverity) {
        StringBuffer result = new StringBuffer(this.name());
        if (!this.equals((Object)fromSeverity)) {
            result.append(" (from ").append((Object)fromSeverity).append(")");
        }
        return result.toString();
    }

    public boolean exceeds(Threshold threshold) {
        return threshold.getThreshold().map(thresholdSeverity -> this.level <= thresholdSeverity.level).orElse(false);
    }

    public static Severity fromValue(String value) throws RuleException {
        if (value == null) {
            return null;
        }
        for (Severity severity : EnumSet.allOf(Severity.class)) {
            if (!severity.value.equals(value.toLowerCase())) continue;
            return severity;
        }
        throw new RuleException("Unknown severity '" + value + "'");
    }

    public static class Threshold {
        public static final String NEVER = "never";
        private final Optional<Severity> threshold;

        public static Threshold from(Severity value) {
            return new Threshold(Optional.of(value));
        }

        public static Threshold from(String value) throws RuleException {
            String trimmedValue = value.trim();
            if (NEVER.equalsIgnoreCase(trimmedValue)) {
                return new Threshold(Optional.empty());
            }
            return new Threshold(Optional.of(Severity.fromValue(trimmedValue)));
        }

        public String toString() {
            return this.threshold.map(severity -> severity.name()).orElse(NEVER);
        }

        public static ThresholdBuilder builder() {
            return new ThresholdBuilder();
        }

        public Optional<Severity> getThreshold() {
            return this.threshold;
        }

        private Threshold(Optional<Severity> threshold) {
            this.threshold = threshold;
        }

        public static class ThresholdBuilder {
            private Optional<Severity> threshold;

            ThresholdBuilder() {
            }

            public ThresholdBuilder threshold(Optional<Severity> threshold) {
                this.threshold = threshold;
                return this;
            }

            public Threshold build() {
                return new Threshold(this.threshold);
            }

            public String toString() {
                return "Severity.Threshold.ThresholdBuilder(threshold=" + this.threshold + ")";
            }
        }
    }
}

