/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.source;

import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;

public class ClasspathRuleSource
extends RuleSource {
    public static final String RULE_RESOURCE_PATH = "META-INF/jqassistant-rules";
    private final ClassLoader classLoader;
    private final String resource;
    private final String relativePath;

    public ClasspathRuleSource(ClassLoader classLoader, String relativePath) {
        this.classLoader = classLoader;
        this.relativePath = relativePath;
        this.resource = "META-INF/jqassistant-rules/" + relativePath;
    }

    @Override
    public String getId() {
        return this.resource;
    }

    @Override
    public URL getURL() {
        return this.getClassLoader().getResource(this.resource);
    }

    @Override
    public Optional<File> getDirectory() {
        return Optional.empty();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ClassLoader currentClassloader = this.getClassLoader();
        InputStream stream = currentClassloader.getResourceAsStream(this.resource);
        if (stream == null) {
            throw new IOException("Cannot load resource from " + this.resource);
        }
        return stream;
    }

    private ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }
}

