/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.source;

import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRuleSource
extends RuleSource {
    private static final Logger log = LoggerFactory.getLogger(FileRuleSource.class);
    private final File directory;
    private final String relativePath;
    private final File file;

    public FileRuleSource(File directory, String relativePath) {
        this.directory = directory;
        this.relativePath = relativePath.replace('\\', '/');
        this.file = new File(directory, relativePath);
    }

    @Override
    public String getId() {
        return this.file.getAbsolutePath();
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return this.file.getAbsoluteFile().toURI().toURL();
    }

    @Override
    public Optional<File> getDirectory() {
        return Optional.of(this.directory);
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public static List<RuleSource> getRuleSources(final File rulesDirectory) throws IOException {
        if (!rulesDirectory.exists()) {
            log.info("Rules directory '{}' does not exist, skipping.", (Object)rulesDirectory.getAbsolutePath());
            return Collections.emptyList();
        }
        log.info("Reading rules from directory '{}'.", (Object)rulesDirectory.getAbsolutePath());
        final LinkedList<RuleSource> ruleSources = new LinkedList<RuleSource>();
        Files.walkFileTree(rulesDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                String relativePath = rulesDirectory.toPath().relativize(path).toString();
                ruleSources.add(new FileRuleSource(rulesDirectory, relativePath));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }
        });
        return ruleSources;
    }
}

