/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.impl.reader;

import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ErrorMessageGenerator {
    private List<Generator> generators = Arrays.asList(new AdditionalProperty(), new Type(), new OneOf(), new Enum(), new RequiredProperty());

    public String generate(RuleSource ruleSource, Set<ValidationMessage> messages) {
        return this.generators.stream().map(g -> g.map(messages)).filter(Optional::isPresent).map(Optional::get).peek(c -> {
            c.rule = ruleSource;
        }).findFirst().orElseThrow(() -> {
            String message = "Failed to find error message generator for a set of validation messages";
            return new IllegalStateException(message);
        }).generate();
    }

    static abstract class Generator {
        private final ValidatorTypeCode typeCode;

        public Generator(ValidatorTypeCode validatorTypeCode) {
            this.typeCode = validatorTypeCode;
        }

        Optional<Combination> map(Set<ValidationMessage> messages) {
            return messages.stream().filter(msg -> msg.getCode().equals(this.typeCode.getErrorCode())).findAny().map((? super T msg) -> new Combination(this, (ValidationMessage)msg));
        }

        abstract String generate(RuleSource var1, ValidationMessage var2);
    }

    static class AdditionalProperty
    extends Generator {
        public AdditionalProperty() {
            super(ValidatorTypeCode.ADDITIONAL_PROPERTIES);
        }

        @Override
        public String generate(RuleSource rule, ValidationMessage message) {
            String key = message.getArguments()[0];
            String path = message.getPath();
            String source = rule.getId();
            return String.format("Rule source '%s' contains the unknown keyword '%s' at '%s'", source, key, path);
        }
    }

    static class Type
    extends Generator {
        private LinkedHashMap<String, String> typeNames = new LinkedHashMap();

        public Type() {
            super(ValidatorTypeCode.TYPE);
            this.typeNames.put("array", "a sequence");
            this.typeNames.put("object", "a map");
            this.typeNames.put("string", "a scalar");
            this.typeNames.put("null", "nothing");
        }

        @Override
        String generate(RuleSource rule, ValidationMessage message) {
            String actualType = this.typeNames.get(message.getArguments()[0]);
            String expectedType = this.typeNames.get(message.getArguments()[1]);
            String source = rule.getId();
            String path = message.getPath();
            return String.format("Rule source '%s' contains at '%s' %s where %s is expected", source, path, actualType, expectedType);
        }
    }

    static class OneOf
    extends Generator {
        public OneOf() {
            super(ValidatorTypeCode.ONE_OF);
        }

        @Override
        String generate(RuleSource rule, ValidationMessage message) {
            String path = message.getPath();
            return String.format("Rule source '%s' can have only one of the given keywords at '%s'", rule.getId(), path);
        }
    }

    static class Enum
    extends Generator {
        public Enum() {
            super(ValidatorTypeCode.ENUM);
        }

        @Override
        String generate(RuleSource rule, ValidationMessage message) {
            String path = message.getPath();
            String validValues = message.getArguments()[0].replace("[", "").replace("]", "");
            return String.format("Rule source '%s' must have one of '%s' at '%s'", rule.getId(), validValues, path);
        }
    }

    static class RequiredProperty
    extends Generator {
        public RequiredProperty() {
            super(ValidatorTypeCode.REQUIRED);
        }

        @Override
        String generate(RuleSource rule, ValidationMessage message) {
            String key = message.getArguments()[0];
            String path = message.getPath();
            String source = rule.getId();
            return String.format("Rule source '%s' misses the keyword '%s' at '%s'", source, key, path);
        }
    }

    private static class Combination {
        RuleSource rule;
        ValidationMessage message;
        Generator generator;

        public Combination(Generator generator, ValidationMessage message) {
            this.generator = generator;
            this.message = message;
        }

        String generate() {
            return this.generator.generate(this.rule, this.message);
        }
    }
}

