/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api;

import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.executor.CollectRulesVisitor;
import com.buschmais.jqassistant.core.rule.api.executor.RuleSetExecutor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import java.util.Set;
import org.slf4j.Logger;

public class RuleHelper {
    public static final String LOG_LINE_PREFIX = "  \"";
    private final Logger logger;

    public RuleHelper(Logger log) {
        this.logger = log;
    }

    public void printRuleSet(RuleSet ruleSet, Rule configuration) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().conceptIds(ruleSet.getConceptBucket().getIds()).constraintIds(ruleSet.getConstraintBucket().getIds()).groupIds(ruleSet.getGroupsBucket().getIds()).build();
        this.printRuleSet(ruleSet, ruleSelection, configuration);
    }

    public void printRuleSet(RuleSet ruleSet, RuleSelection ruleSelection, Rule configuration) throws RuleException {
        CollectRulesVisitor visitor = this.getAllRules(ruleSet, ruleSelection, configuration);
        this.printValidRules(visitor);
        this.printMissingRules(visitor);
    }

    private void printValidRules(CollectRulesVisitor visitor) {
        this.logger.info("Groups [" + visitor.getGroups().size() + "]");
        for (Group group : visitor.getGroups()) {
            this.logger.info(LOG_LINE_PREFIX + group.getId() + "\"");
        }
        this.logger.info("Constraints [" + visitor.getConstraints().size() + "]");
        for (Constraint constraint : visitor.getConstraints().keySet()) {
            this.logger.info(LOG_LINE_PREFIX + constraint.getId() + "\" - " + constraint.getDescription());
        }
        this.logger.info("Concepts [" + visitor.getConcepts().size() + "]");
        for (Concept concept : visitor.getConcepts().keySet()) {
            this.logger.info(LOG_LINE_PREFIX + concept.getId() + "\" - " + concept.getDescription());
        }
    }

    private CollectRulesVisitor getAllRules(RuleSet ruleSet, RuleSelection ruleSelection, Rule configuration) throws RuleException {
        CollectRulesVisitor visitor = new CollectRulesVisitor();
        RuleSetExecutor<Boolean> executor = new RuleSetExecutor<Boolean>(visitor, configuration);
        executor.execute(ruleSet, ruleSelection);
        return visitor;
    }

    private void printMissingRules(CollectRulesVisitor visitor) {
        Set<String> set;
        Set<String> missingConstraints;
        Set<String> missingConcepts = visitor.getMissingConcepts();
        if (!missingConcepts.isEmpty()) {
            this.logger.info("Missing concepts [{}]", (Object)missingConcepts.size());
            for (String string : missingConcepts) {
                this.logger.warn("  \"{}", (Object)string);
            }
        }
        if (!(missingConstraints = visitor.getMissingConstraints()).isEmpty()) {
            this.logger.info("Missing constraints [{}]", (Object)missingConstraints.size());
            for (String missingConstraint : missingConstraints) {
                this.logger.warn("  \"{}", (Object)missingConstraint);
            }
        }
        if (!(set = visitor.getMissingGroups()).isEmpty()) {
            this.logger.info("Missing groups [{}]", (Object)set.size());
            for (String missingGroup : set) {
                this.logger.warn("  \"{}", (Object)missingGroup);
            }
        }
    }
}

