/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.executor;

import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.executor.RuleVisitor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSetExecutor<R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleSetExecutor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSetExecutor.class);
    private final Map<Concept, R> executedConcepts = new HashMap<Concept, R>();
    private final Set<Constraint> executedConstraints = new LinkedHashSet<Constraint>();
    private final Set<Group> executedGroups = new LinkedHashSet<Group>();
    private final RuleVisitor<R> ruleVisitor;
    private final Rule configuration;

    public RuleSetExecutor(RuleVisitor<R> ruleVisitor, Rule configuration) {
        this.ruleVisitor = ruleVisitor;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RuleSet ruleSet, RuleSelection ruleSelection) throws RuleException {
        this.ruleVisitor.beforeRules();
        try {
            for (String conceptPattern : ruleSelection.getConceptIds()) {
                this.applyConcepts(ruleSet, conceptPattern, null);
            }
            for (String groupPattern : ruleSelection.getGroupIds()) {
                this.executeGroups(ruleSet, groupPattern, ruleSelection.getExcludeConstraintIds(), null);
            }
            for (String constraintPattern : ruleSelection.getConstraintIds()) {
                this.validateConstraints(ruleSet, constraintPattern, ruleSelection.getExcludeConstraintIds(), null);
            }
        }
        finally {
            this.ruleVisitor.afterRules();
        }
        if (this.executedConcepts.isEmpty() && this.executedConstraints.isEmpty()) {
            log.warn("No concepts or constraints were executed.");
        }
    }

    private void executeGroup(RuleSet ruleSet, Group group, Set<String> excludedConstraintIds, Severity overriddenSeverity) throws RuleException {
        if (!this.executedGroups.contains(group)) {
            Severity groupSeverity = this.getEffectiveSeverity(overriddenSeverity, group.getSeverity());
            this.ruleVisitor.beforeGroup(group, groupSeverity);
            for (Map.Entry<String, Severity> conceptEntry : group.getConcepts().entrySet()) {
                this.applyConcepts(ruleSet, conceptEntry.getKey(), this.getEffectiveSeverity(conceptEntry.getValue(), groupSeverity));
            }
            for (Map.Entry<String, Severity> groupEntry : group.getGroups().entrySet()) {
                Severity effectiveSeverity = this.getEffectiveSeverity(groupEntry.getValue(), groupSeverity);
                this.executeGroups(ruleSet, groupEntry.getKey(), excludedConstraintIds, effectiveSeverity);
            }
            Map<String, Severity> constraints = group.getConstraints();
            for (Map.Entry<String, Severity> constraintEntry : constraints.entrySet()) {
                Severity effectiveSeverity = this.getEffectiveSeverity(constraintEntry.getValue(), groupSeverity);
                this.validateConstraints(ruleSet, constraintEntry.getKey(), excludedConstraintIds, effectiveSeverity);
            }
            this.ruleVisitor.afterGroup(group);
            this.executedGroups.add(group);
        }
    }

    private void applyConcepts(RuleSet ruleSet, String conceptPattern, Severity overriddenSeverity) throws RuleException {
        List matchingConcepts = ruleSet.getConceptBucket().match(conceptPattern);
        if (matchingConcepts.isEmpty()) {
            LOGGER.warn("Could not find concepts matching to '{}'.", (Object)conceptPattern);
        } else {
            for (Concept matchingConcept : matchingConcepts) {
                this.applyConcept(ruleSet, matchingConcept, overriddenSeverity, new LinkedHashSet<Concept>());
            }
        }
    }

    private void executeGroups(RuleSet ruleSet, String groupPattern, Set<String> excludedConstraintIds, Severity overridingSeverity) throws RuleException {
        List matchingGroups = ruleSet.getGroupsBucket().match(groupPattern);
        if (matchingGroups.isEmpty()) {
            LOGGER.warn("Could not find groups matching to '{}'.", (Object)groupPattern);
        } else {
            for (Group matchingGroup : matchingGroups) {
                this.executeGroup(ruleSet, matchingGroup, excludedConstraintIds, overridingSeverity);
            }
        }
    }

    private void validateConstraints(RuleSet ruleSet, String constraintPattern, Set<String> excludedConstraintIds, Severity overriddenSeverity) throws RuleException {
        List matchingConstraints = ruleSet.getConstraintBucket().match(constraintPattern);
        if (matchingConstraints.isEmpty()) {
            LOGGER.warn("Could not find constraints matching to '{}'.", (Object)constraintPattern);
        } else {
            for (Constraint matchingConstraint : matchingConstraints) {
                String constraintId = matchingConstraint.getId();
                if (excludedConstraintIds.contains(constraintId)) {
                    log.info("Skipping excluded constraint '{}'.", (Object)constraintId);
                    continue;
                }
                this.validateConstraint(ruleSet, matchingConstraint, overriddenSeverity);
            }
        }
    }

    private Severity getEffectiveSeverity(Severity ... severities) {
        for (Severity severity : severities) {
            if (severity == null) continue;
            return severity;
        }
        return null;
    }

    private void validateConstraint(RuleSet ruleSet, Constraint constraint, Severity overriddenSeverity) throws RuleException {
        if (!this.executedConstraints.contains(constraint)) {
            Severity effectiveSeverity = this.getEffectiveSeverity(overriddenSeverity, constraint.getSeverity());
            Map<Map.Entry<Concept, Boolean>, R> requiredConceptResults = this.applyRequiredConcepts(ruleSet, constraint, new LinkedHashSet<Concept>());
            if (this.requiredConceptsAreSuccessful(requiredConceptResults)) {
                this.checkDeprecation(constraint);
                this.ruleVisitor.visitConstraint(constraint, effectiveSeverity, requiredConceptResults);
            } else {
                this.ruleVisitor.skipConstraint(constraint, effectiveSeverity, requiredConceptResults);
            }
            this.executedConstraints.add(constraint);
        }
    }

    private R applyConcept(RuleSet ruleSet, Concept concept, Severity overriddenSeverity, Set<Concept> executionStack) throws RuleException {
        R result = this.executedConcepts.get(concept);
        if (result == null) {
            executionStack.add(concept);
            Severity effectiveSeverity = this.getEffectiveSeverity(overriddenSeverity, concept.getSeverity());
            Map<Map.Entry<Concept, Boolean>, R> requiredConceptResults = this.applyAllRequiredConcepts(ruleSet, concept, executionStack);
            if (this.requiredConceptsAreSuccessful(requiredConceptResults)) {
                Map<Concept, R> providedConceptResults = this.applyProvidingConcepts(ruleSet, concept, overriddenSeverity, executionStack);
                this.checkDeprecation(concept);
                result = this.ruleVisitor.visitConcept(concept, effectiveSeverity, requiredConceptResults, providedConceptResults);
            } else {
                this.ruleVisitor.skipConcept(concept, effectiveSeverity, requiredConceptResults);
            }
            executionStack.remove(concept);
            this.executedConcepts.put(concept, result);
        }
        return result;
    }

    private boolean requiredConceptsAreSuccessful(Map<Map.Entry<Concept, Boolean>, R> requiredConceptResults) {
        return requiredConceptResults.entrySet().stream().allMatch(entry -> {
            Boolean isOptional = (Boolean)((Map.Entry)entry.getKey()).getValue();
            return (isOptional != null ? isOptional != false : this.configuration.requiredConceptsAreOptionalByDefault()) || this.ruleVisitor.isSuccess(entry.getValue());
        });
    }

    private Map<Concept, R> applyProvidingConcepts(RuleSet ruleSet, Concept concept, Severity overriddenSeverity, Set<Concept> stack) throws RuleException {
        LinkedHashMap<Concept, R> results = new LinkedHashMap<Concept, R>();
        Severity providedSeverity = concept.getSeverity();
        for (String providingConceptId : ruleSet.getProvidedConcepts().getOrDefault(concept.getId(), Collections.emptySet())) {
            Concept providingConcept = (Concept)ruleSet.getConceptBucket().getById(providingConceptId);
            Severity providingSeverity = providingConcept.getSeverity();
            Severity effectiveSeverity = this.getEffectiveSeverity(overriddenSeverity, providedSeverity.getLevel() < providingSeverity.getLevel() ? providedSeverity : providingSeverity);
            R result = this.applyConcept(ruleSet, providingConcept, effectiveSeverity, stack);
            results.put(providingConcept, result);
        }
        return results;
    }

    private Map<Map.Entry<Concept, Boolean>, R> applyAllRequiredConcepts(RuleSet ruleSet, Concept concept, Set<Concept> stack) throws RuleException {
        HashMap<Map.Entry<Concept, Boolean>, R> requiredConcepts = new HashMap<Map.Entry<Concept, Boolean>, R>();
        Set<String> conceptIds = ruleSet.getConceptBucket().getIds();
        for (String providedConceptId : ruleSet.getProvidingConcepts().getOrDefault(concept.getId(), Collections.emptySet())) {
            if (conceptIds.contains(providedConceptId)) {
                Concept providedConcept = (Concept)ruleSet.getConceptBucket().getById(providedConceptId);
                requiredConcepts.putAll(this.applyAllRequiredConcepts(ruleSet, providedConcept, stack));
                continue;
            }
            log.warn("Cannot resolve provided concept '{}' (provided by concept '{}').", (Object)providedConceptId, (Object)concept.getId());
        }
        requiredConcepts.putAll(this.applyRequiredConcepts(ruleSet, concept, stack));
        return requiredConcepts;
    }

    private Map<Map.Entry<Concept, Boolean>, R> applyRequiredConcepts(RuleSet ruleSet, ExecutableRule<?> rule, Set<Concept> stack) throws RuleException {
        HashMap<AbstractMap.SimpleEntry<Concept, Boolean>, R> requiredConcepts = new HashMap<AbstractMap.SimpleEntry<Concept, Boolean>, R>();
        for (Map.Entry<String, Boolean> entry : rule.getRequiresConcepts().entrySet()) {
            for (Concept requiredConcept : ruleSet.getConceptBucket().match(entry.getKey())) {
                if (stack.contains(requiredConcept)) continue;
                R conceptResult = this.applyConcept(ruleSet, requiredConcept, null, stack);
                requiredConcepts.put(new AbstractMap.SimpleEntry<Concept, Boolean>(requiredConcept, entry.getValue()), conceptResult);
            }
        }
        return requiredConcepts;
    }

    private void checkDeprecation(ExecutableRule<?> executableRule) {
        String deprecation = executableRule.getDeprecation();
        if (deprecation != null) {
            log.warn("Rule '{}' is deprecated: {} ({})", new Object[]{executableRule.getId(), executableRule.getDeprecation(), executableRule.getSource().getId()});
        }
    }
}

