/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.ConceptBucket;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ConstraintBucket;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.GroupsBucket;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSetBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleSetBuilder.class);
    private final DefaultRuleSet ruleSet = new DefaultRuleSet();

    private RuleSetBuilder() {
    }

    public static RuleSetBuilder newInstance() {
        return new RuleSetBuilder();
    }

    public RuleSetBuilder addConcept(Concept concept) throws RuleException {
        this.ruleSet.conceptBucket.add(concept);
        String providingConceptId = concept.getId();
        for (String providedConceptId : concept.getProvidedConcepts()) {
            this.updateProvidedConcepts(providedConceptId, providingConceptId);
        }
        return this;
    }

    public RuleSetBuilder addConstraint(Constraint constraint) throws RuleException {
        this.ruleSet.constraintBucket.add(constraint);
        return this;
    }

    public RuleSetBuilder addGroup(Group group) throws RuleException {
        this.ruleSet.groupsBucket.add(group);
        for (Map.Entry<String, Set<String>> entry : group.getProvidedConcepts().entrySet()) {
            String providedConceptId = entry.getKey();
            for (String providingConceptId : entry.getValue()) {
                this.updateProvidedConcepts(providedConceptId, providingConceptId);
            }
        }
        return this;
    }

    private void updateProvidedConcepts(String providedConceptId, String providingConceptId) {
        this.ruleSet.providingConcepts.computeIfAbsent(providingConceptId, id -> new LinkedHashSet()).add(providedConceptId);
        this.ruleSet.providedConcepts.computeIfAbsent(providedConceptId, id -> new LinkedHashSet()).add(providingConceptId);
    }

    public RuleSet getRuleSet() throws RuleException {
        this.validate();
        return this.ruleSet;
    }

    private void validate() throws RuleException {
        Set<String> conceptIds = this.ruleSet.getConceptBucket().getIds();
        for (Map.Entry<String, Set<String>> entry : this.ruleSet.getProvidedConcepts().entrySet()) {
            String providedConceptId = entry.getKey();
            if (conceptIds.contains(providedConceptId)) continue;
            for (String providingConceptId : entry.getValue()) {
                log.warn("Concept {} provides non-resolvable concept with id '{}'.", this.ruleSet.getConceptBucket().getById(providingConceptId), (Object)providedConceptId);
            }
        }
    }

    private static class DefaultRuleSet
    implements RuleSet {
        private final ConceptBucket conceptBucket = new ConceptBucket();
        private final Map<String, Set<String>> providingConcepts = new HashMap<String, Set<String>>();
        private final ConstraintBucket constraintBucket = new ConstraintBucket();
        private final GroupsBucket groupsBucket = new GroupsBucket();
        private final Map<String, Set<String>> providedConcepts = new HashMap<String, Set<String>>();

        private DefaultRuleSet() {
        }

        @Override
        @Generated
        public ConceptBucket getConceptBucket() {
            return this.conceptBucket;
        }

        @Override
        @Generated
        public Map<String, Set<String>> getProvidingConcepts() {
            return this.providingConcepts;
        }

        @Override
        @Generated
        public ConstraintBucket getConstraintBucket() {
            return this.constraintBucket;
        }

        @Override
        @Generated
        public GroupsBucket getGroupsBucket() {
            return this.groupsBucket;
        }

        @Override
        @Generated
        public Map<String, Set<String>> getProvidedConcepts() {
            return this.providedConcepts;
        }

        @Generated
        public String toString() {
            return "RuleSetBuilder.DefaultRuleSet(conceptBucket=" + this.getConceptBucket() + ", providingConcepts=" + this.getProvidingConcepts() + ", constraintBucket=" + this.getConstraintBucket() + ", groupsBucket=" + this.getGroupsBucket() + ", providedConcepts=" + this.getProvidedConcepts() + ")";
        }
    }
}

