/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.impl.reader;

public class IndentHelper {
    private IndentHelper() {
    }

    public static String removeIndent(String text) {
        if (text == null) {
            return null;
        }
        String textWithoutEmptyLines = IndentHelper.removeBlankLeadingAndTrailingLines(text);
        String[] lines = textWithoutEmptyLines.split("\\n");
        if (text.isBlank()) {
            return textWithoutEmptyLines;
        }
        int indent = IndentHelper.getIndent(lines);
        return IndentHelper.removeIndent(lines, indent);
    }

    private static String removeBlankLeadingAndTrailingLines(String text) {
        String[] lines = text.split("\\n");
        int startIndex = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].isBlank()) continue;
            startIndex = i;
            break;
        }
        int lastIndex = lines.length - 1;
        for (int i = lines.length - 1; i >= 0; --i) {
            if (lines[i].isBlank()) continue;
            lastIndex = i;
            break;
        }
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = startIndex; i <= lastIndex; ++i) {
            resultBuilder.append(lines[i]);
            if (i >= lastIndex) continue;
            resultBuilder.append("\n");
        }
        return resultBuilder.toString();
    }

    private static int getIndent(String[] lines) {
        int currentColumn = 0;
        while (true) {
            String prevChar = null;
            for (String line : lines) {
                if (line.isBlank()) continue;
                if (currentColumn == line.length()) {
                    return currentColumn;
                }
                String currentChar = line.substring(currentColumn, currentColumn + 1);
                if (!currentChar.isBlank() || prevChar != null && !prevChar.equals(currentChar)) {
                    return currentColumn;
                }
                prevChar = currentChar;
            }
            ++currentColumn;
        }
    }

    private static String removeIndent(String[] lines, int indent) {
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].replaceAll("\\s+$", "");
            if (!line.isBlank()) {
                resultBuilder.append(line.substring(indent));
            } else {
                resultBuilder.append(lines[i]);
            }
            if (i >= lines.length - 1) continue;
            resultBuilder.append("\n");
        }
        return resultBuilder.toString();
    }
}

