/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.impl.reader;

import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.ValidationResult;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

class JsonSchemaValidator {
    private static final String JSON_SCHEMA = "/META-INF/schema/jqassistant-rule-v2.2.schema.json";
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final JsonSchema schema;

    public JsonSchemaValidator() throws RuleException {
        JsonSchemaFactory bluePrintFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909);
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.builder((JsonSchemaFactory)bluePrintFactory).build();
        try (InputStream inputStream = JsonSchemaValidator.class.getResourceAsStream(JSON_SCHEMA);){
            this.schema = schemaFactory.getSchema(inputStream);
        }
        catch (IOException e) {
            String message = String.format("Failed to load schema from %s", JSON_SCHEMA);
            throw new RuleException(message);
        }
    }

    public ValidationResult validate(RuleSource ruleSource) throws IOException {
        ValidationResult result = new ValidationResult();
        try (InputStream inputStream = ruleSource.getInputStream();){
            JsonNode rootNode = this.mapper.readTree(inputStream);
            Set validationMessages = this.schema.validate(rootNode);
            result.setValidationMessages(validationMessages);
            result.setSourceWasEmpty(false);
        }
        return result;
    }
}

