/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.impl.reader;

import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.CypherExecutable;
import com.buschmais.jqassistant.core.rule.api.model.Executable;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.Parameter;
import com.buschmais.jqassistant.core.rule.api.model.Report;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSetBuilder;
import com.buschmais.jqassistant.core.rule.api.model.ScriptExecutable;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.model.Verification;
import com.buschmais.jqassistant.core.rule.api.reader.AggregationVerification;
import com.buschmais.jqassistant.core.rule.api.reader.RowCountVerification;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.impl.SourceExecutable;
import com.buschmais.jqassistant.core.rule.impl.reader.AbstractRuleParserPlugin;
import com.buschmais.jqassistant.core.rule.impl.reader.IndentHelper;
import com.buschmais.jqassistant.core.shared.xml.JAXBHelper;
import com.buschmais.jqassistant.core.shared.xml.XmlHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.validation.Schema;
import lombok.Generated;
import org.jqassistant.schema.rule.v2.AggregationVerificationType;
import org.jqassistant.schema.rule.v2.ConceptType;
import org.jqassistant.schema.rule.v2.ConstraintType;
import org.jqassistant.schema.rule.v2.CypherType;
import org.jqassistant.schema.rule.v2.GroupType;
import org.jqassistant.schema.rule.v2.IncludeConceptType;
import org.jqassistant.schema.rule.v2.IncludedReferenceType;
import org.jqassistant.schema.rule.v2.JqassistantRules;
import org.jqassistant.schema.rule.v2.OptionalReferenceType;
import org.jqassistant.schema.rule.v2.ParameterType;
import org.jqassistant.schema.rule.v2.PropertyType;
import org.jqassistant.schema.rule.v2.ReferenceType;
import org.jqassistant.schema.rule.v2.ReportType;
import org.jqassistant.schema.rule.v2.RowCountVerificationType;
import org.jqassistant.schema.rule.v2.SeverityEnumType;
import org.jqassistant.schema.rule.v2.SeverityRuleType;
import org.jqassistant.schema.rule.v2.SourceType;
import org.jqassistant.schema.rule.v2.VerificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRuleParserPlugin
extends AbstractRuleParserPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlRuleParserPlugin.class);
    private static final String NAMESPACE_RULE = "http://schema.jqassistant.org/rule/v2.2";
    private static final String RULES_SCHEMA_LOCATION = "/META-INF/schema/jqassistant-rule-v2.2.xsd";
    private static final Schema SCHEMA = XmlHelper.getSchema((String)"/META-INF/schema/jqassistant-rule-v2.2.xsd");
    private JAXBHelper<JqassistantRules> jaxbHelper;

    @Override
    public void initialize() {
        this.jaxbHelper = new JAXBHelper(JqassistantRules.class, SCHEMA, NAMESPACE_RULE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean accepts(RuleSource ruleSource) {
        if (!ruleSource.getId().toLowerCase().endsWith(".xml")) return false;
        if (!XmlHelper.rootElementMatches(ruleSource::getInputStream, qname -> "jqassistant-rules".equals(qname.getLocalPart()))) return false;
        return true;
    }

    @Override
    public void doParse(RuleSource ruleSource, RuleSetBuilder ruleSetBuilder) throws RuleException {
        List<JqassistantRules> rules = this.readXmlSource(ruleSource);
        this.convert(rules, ruleSource, ruleSetBuilder);
    }

    private List<JqassistantRules> readXmlSource(RuleSource ruleSource) {
        ArrayList<JqassistantRules> rules = new ArrayList<JqassistantRules>();
        try {
            JqassistantRules jqassistantRules = (JqassistantRules)this.jaxbHelper.unmarshal(ruleSource.getURL());
            rules.add(jqassistantRules);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read rules from '" + ruleSource.getId() + "'.", e);
        }
        return rules;
    }

    private void convert(List<JqassistantRules> rules, RuleSource ruleSource, RuleSetBuilder builder) throws RuleException {
        for (JqassistantRules rule : rules) {
            List severityRuleTypes = rule.getConceptOrConstraintOrGroup();
            for (SeverityRuleType severityRuleType : severityRuleTypes) {
                String id = severityRuleType.getId();
                if (severityRuleType instanceof ConceptType) {
                    Concept concept = this.createConcept(id, ruleSource, (ConceptType)severityRuleType);
                    builder.addConcept(concept);
                    continue;
                }
                if (severityRuleType instanceof ConstraintType) {
                    Constraint constraint = this.createConstraint(id, ruleSource, (ConstraintType)severityRuleType);
                    builder.addConstraint(constraint);
                    continue;
                }
                if (!(severityRuleType instanceof GroupType)) continue;
                Group group = this.createGroup(id, ruleSource, (GroupType)severityRuleType);
                builder.addGroup(group);
            }
        }
    }

    private Group createGroup(String id, RuleSource ruleSource, GroupType referencableType) throws RuleException {
        SeverityEnumType severityType = referencableType.getSeverity();
        Severity severity = this.getSeverity(severityType, this::getDefaultGroupSeverity);
        Map<String, Severity> includeConcepts = this.getIncludedReferences(referencableType.getIncludeConcept());
        Map<String, Set<String>> providedConcepts = this.getProvidedConcepts(referencableType.getIncludeConcept());
        Map<String, Severity> includeConstraints = this.getIncludedReferences(referencableType.getIncludeConstraint());
        Map<String, Severity> includeGroups = this.getIncludedReferences(referencableType.getIncludeGroup());
        return (Group)((Group.GroupBuilder)((Group.GroupBuilder)((Group.GroupBuilder)Group.builder().id(id)).severity(severity)).ruleSource(ruleSource)).concepts(includeConcepts).providedConcepts(providedConcepts).constraints(includeConstraints).groups(includeGroups).build();
    }

    private Concept createConcept(String id, RuleSource ruleSource, ConceptType conceptType) throws RuleException {
        String description = IndentHelper.removeIndent(conceptType.getDescription());
        Executable<?> executable = this.createExecutable(conceptType.getSource(), conceptType.getCypher(), conceptType.getScript());
        Map<String, Parameter> parameters = this.getRequiredParameters(conceptType.getRequiresParameter());
        SeverityEnumType severityType = conceptType.getSeverity();
        Severity severity = this.getSeverity(severityType, this::getDefaultConceptSeverity);
        List requiresConcept = conceptType.getRequiresConcept();
        Map<String, Boolean> requiresConcepts = this.getRequiresConcepts(requiresConcept);
        List providesConcept = conceptType.getProvidesConcept();
        Set<String> providesConcepts = providesConcept.stream().map(ReferenceType::getRefId).collect(Collectors.toSet());
        String deprecated = conceptType.getDeprecated();
        Verification verification = this.getVerification(conceptType.getVerify());
        Report report = this.getReport(conceptType.getReport());
        return (Concept)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)((Concept.ConceptBuilder)Concept.builder().id(id)).description(description)).ruleSource(ruleSource)).severity(severity)).deprecation(deprecated)).executable(executable)).parameters(parameters)).providedConcepts(providesConcepts).requiresConcepts(requiresConcepts)).verification(verification)).report(report)).build();
    }

    private Constraint createConstraint(String id, RuleSource ruleSource, ConstraintType constraintType) throws RuleException {
        Executable<?> executable = this.createExecutable(constraintType.getSource(), constraintType.getCypher(), constraintType.getScript());
        String description = IndentHelper.removeIndent(constraintType.getDescription());
        Map<String, Parameter> parameters = this.getRequiredParameters(constraintType.getRequiresParameter());
        SeverityEnumType severityType = constraintType.getSeverity();
        Severity severity = this.getSeverity(severityType, this::getDefaultConstraintSeverity);
        List requiresConcept = constraintType.getRequiresConcept();
        Map<String, Boolean> requiresConcepts = this.getRequiresConcepts(requiresConcept);
        String deprecated = constraintType.getDeprecated();
        Verification verification = this.getVerification(constraintType.getVerify());
        Report report = this.getReport(constraintType.getReport());
        return (Constraint)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)((Constraint.ConstraintBuilder)Constraint.builder().id(id)).description(description)).ruleSource(ruleSource)).severity(severity)).deprecation(deprecated)).executable(executable)).parameters(parameters)).requiresConcepts(requiresConcepts)).verification(verification)).report(report)).build();
    }

    private Executable<?> createExecutable(SourceType source, CypherType cypherType, SourceType scriptType) {
        if (source != null) {
            return new SourceExecutable<String>(source.getLanguage().toLowerCase(), source.getValue(), String.class);
        }
        if (cypherType != null) {
            return new CypherExecutable(cypherType.getValue());
        }
        if (scriptType != null) {
            return new ScriptExecutable(scriptType.getLanguage().toLowerCase(), scriptType.getValue());
        }
        return null;
    }

    private Verification getVerification(VerificationType verificationType) throws RuleException {
        if (verificationType != null) {
            RowCountVerificationType rowCountVerificationType = verificationType.getRowCount();
            AggregationVerificationType aggregationVerificationType = verificationType.getAggregation();
            if (aggregationVerificationType != null) {
                return AggregationVerification.builder().column(aggregationVerificationType.getColumn()).min(aggregationVerificationType.getMin()).max(aggregationVerificationType.getMax()).build();
            }
            if (rowCountVerificationType != null) {
                return RowCountVerification.builder().min(rowCountVerificationType.getMin()).max(rowCountVerificationType.getMax()).build();
            }
            throw new RuleException("Unsupported verification " + verificationType);
        }
        return null;
    }

    private Report getReport(ReportType reportType) {
        String type = null;
        String primaryColumn = null;
        Properties properties = new Properties();
        if (reportType != null) {
            type = reportType.getType();
            primaryColumn = reportType.getPrimaryColumn();
            for (PropertyType propertyType : reportType.getProperty()) {
                properties.setProperty(propertyType.getName(), propertyType.getValue());
            }
        }
        Report.ReportBuilder reportBuilder = Report.builder().primaryColumn(primaryColumn).properties(properties);
        if (type != null) {
            reportBuilder.selectedTypes(Report.selectTypes(type));
        }
        return reportBuilder.build();
    }

    private Map<String, Boolean> getRequiresConcepts(List<? extends OptionalReferenceType> referenceTypes) {
        HashMap<String, Boolean> references = new HashMap<String, Boolean>();
        for (OptionalReferenceType optionalReferenceType : referenceTypes) {
            references.put(optionalReferenceType.getRefId(), optionalReferenceType.isOptional());
        }
        return references;
    }

    private Map<String, Set<String>> getProvidedConcepts(List<IncludeConceptType> conceptTypes) {
        HashMap<String, Set<String>> providedConcepts = new HashMap<String, Set<String>>();
        for (IncludeConceptType conceptType : conceptTypes) {
            for (ReferenceType referenceType : conceptType.getProvidesConcept()) {
                String providingConceptId = conceptType.getRefId();
                providedConcepts.computeIfAbsent(referenceType.getRefId(), providedConceptId -> new HashSet()).add(providingConceptId);
            }
        }
        return providedConcepts;
    }

    private Map<String, Severity> getIncludedReferences(List<? extends IncludedReferenceType> referenceType) throws RuleException {
        HashMap<String, Severity> references = new HashMap<String, Severity>();
        for (IncludedReferenceType includedReferenceType : referenceType) {
            Severity severity = this.getSeverity(includedReferenceType.getSeverity(), this::getDefaultIncludeSeverity);
            references.put(includedReferenceType.getRefId(), severity);
        }
        return references;
    }

    private Map<String, Parameter> getRequiredParameters(List<ParameterType> parameterTypes) throws RuleException {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        for (ParameterType parameterType : parameterTypes) {
            Parameter.Type type;
            switch (parameterType.getType()) {
                case CHAR: {
                    type = Parameter.Type.CHAR;
                    break;
                }
                case BYTE: {
                    type = Parameter.Type.BYTE;
                    break;
                }
                case SHORT: {
                    type = Parameter.Type.SHORT;
                    break;
                }
                case INT: {
                    type = Parameter.Type.INT;
                    break;
                }
                case LONG: {
                    type = Parameter.Type.LONG;
                    break;
                }
                case FLOAT: {
                    type = Parameter.Type.FLOAT;
                    break;
                }
                case DOUBLE: {
                    type = Parameter.Type.DOUBLE;
                    break;
                }
                case BOOLEAN: {
                    type = Parameter.Type.BOOLEAN;
                    break;
                }
                case STRING: {
                    type = Parameter.Type.STRING;
                    break;
                }
                default: {
                    throw new RuleException("Unsupported type " + parameterType.getType() + " of parameter " + parameterType.getName());
                }
            }
            String defaultValue = parameterType.getDefaultValue();
            Parameter parameter = new Parameter(parameterType.getName(), type, defaultValue != null ? type.parse(defaultValue) : null);
            parameters.put(parameterType.getName(), parameter);
        }
        return parameters;
    }

    private Severity getSeverity(SeverityEnumType severityType, Supplier<Severity> defaultSeveritySupplier) throws RuleException {
        String value = severityType != null ? severityType.value() : null;
        return this.getSeverity(value, defaultSeveritySupplier);
    }
}

