/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.executor;

import com.buschmais.jqassistant.core.rule.api.executor.AbstractRuleVisitor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.Rule;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CollectRulesVisitor
extends AbstractRuleVisitor<Boolean> {
    private static final Comparator<Rule> RULE_COMPARATOR = Comparator.comparing(Rule::getId);
    private Map<Concept, Severity> concepts = new TreeMap<Rule, Severity>(RULE_COMPARATOR);
    private Map<Constraint, Severity> constraints = new TreeMap<Rule, Severity>(RULE_COMPARATOR);
    private Set<Group> groups = new TreeSet<Rule>(RULE_COMPARATOR);

    @Override
    public Boolean visitConcept(Concept concept, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Boolean> requiredConceptResults, Map<Concept, Boolean> providingConceptResults) {
        this.concepts.put(concept, effectiveSeverity);
        return true;
    }

    @Override
    public Boolean visitConstraint(Constraint constraint, Severity effectiveSeverity, Map<Map.Entry<Concept, Boolean>, Boolean> requiredConceptResults) {
        this.constraints.put(constraint, effectiveSeverity);
        return true;
    }

    @Override
    public void beforeGroup(Group group, Severity effectiveSeverity) {
        this.groups.add(group);
    }

    public Map<Concept, Severity> getConcepts() {
        return this.concepts;
    }

    public Map<Constraint, Severity> getConstraints() {
        return this.constraints;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }
}

