/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.filter;

import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public final class RuleFilter {
    private RuleFilter() {
    }

    public static SortedSet<String> match(Iterable<String> rules, String filter) {
        TreeSet<String> matches = new TreeSet<String>();
        if (filter != null) {
            List<String> rulePatterns = Arrays.asList(filter.split("\\s*,\\s*"));
            List<String> includePatterns = rulePatterns.stream().filter(pattern -> !pattern.startsWith("!")).collect(Collectors.toList());
            List<String> excludePatterns = rulePatterns.stream().filter(pattern -> pattern.startsWith("!")).map(pattern -> pattern.substring(1)).collect(Collectors.toList());
            RuleFilter.apply(rules, includePatterns, rule -> matches.add((String)rule));
            RuleFilter.apply(rules, excludePatterns, rule -> matches.remove(rule));
        }
        return matches;
    }

    private static void apply(Iterable<String> rules, List<String> patterns, Consumer<String> consumer) {
        for (String rule : rules) {
            for (String pattern : patterns) {
                if (!RuleFilter.matches(rule, pattern)) continue;
                consumer.accept(rule);
            }
        }
    }

    public static boolean matches(String rule, String pattern) {
        return FilenameUtils.wildcardMatch((String)rule, (String)pattern);
    }
}

