/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.filter.RuleFilter;
import com.buschmais.jqassistant.core.rule.api.model.AbstractRule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;

public abstract class AbstractRuleBucket<T extends AbstractRule> {
    private TreeMap<String, T> rules = new TreeMap();

    public int size() {
        return this.rules.size();
    }

    protected void add(T rule) throws RuleException {
        AbstractRule existingRule = (AbstractRule)this.rules.put(((AbstractRule)rule).getId(), rule);
        if (existingRule != null) {
            throw new RuleException("Cannot add rule with id '" + ((AbstractRule)rule).getId() + "' from '" + ((AbstractRule)rule).getSource().getId() + "' as it has already been defined in '" + existingRule.getSource().getId() + "'.");
        }
    }

    protected abstract String getRuleTypeName();

    public Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.rules.values());
    }

    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.rules.keySet());
    }

    public T getById(String id) throws RuleException {
        AbstractRule rule = (AbstractRule)this.rules.get(id);
        if (null == rule) {
            throw new RuleException("Cannot find " + this.getRuleTypeName() + " " + id);
        }
        return (T)rule;
    }

    public List<T> match(String pattern) throws RuleException {
        ArrayList<AbstractRule> matches = new ArrayList<AbstractRule>();
        if (pattern.contains("?") || pattern.contains("*")) {
            for (Map.Entry<String, T> entry : this.rules.entrySet()) {
                if (!RuleFilter.matches(entry.getKey(), pattern)) continue;
                matches.add((AbstractRule)entry.getValue());
            }
        } else {
            matches.add((AbstractRule)this.getById(pattern));
        }
        return matches;
    }

    public <B extends AbstractRuleBucket<T>> void add(B bucket) throws RuleException {
        for (String ruleId : bucket.getIds()) {
            T rule = bucket.getById(ruleId);
            this.add((B)rule);
        }
    }

    @Generated
    public String toString() {
        return "AbstractRuleBucket(rules=" + String.valueOf(this.rules) + ")";
    }
}

