/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.ConceptBucket;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ConstraintBucket;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.GroupsBucket;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSetBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleSetBuilder.class);
    private final DefaultRuleSet ruleSet = new DefaultRuleSet();

    private RuleSetBuilder() {
    }

    public static RuleSetBuilder newInstance() {
        return new RuleSetBuilder();
    }

    public RuleSetBuilder addConcept(Concept concept) throws RuleException {
        this.ruleSet.conceptBucket.add(concept);
        this.updateProvidedConcepts(concept.getProvidedConcepts());
        return this;
    }

    public RuleSetBuilder addConstraint(Constraint constraint) throws RuleException {
        this.ruleSet.constraintBucket.add(constraint);
        return this;
    }

    public RuleSetBuilder addGroup(Group group) throws RuleException {
        this.ruleSet.groupsBucket.add(group);
        for (Map.Entry<String, Set<Concept.ProvidedConcept>> entry : group.getProvidedConcepts().entrySet()) {
            this.updateProvidedConcepts(entry.getValue());
        }
        return this;
    }

    private void updateProvidedConcepts(Set<Concept.ProvidedConcept> providedConcepts) {
        for (Concept.ProvidedConcept providedConcept : providedConcepts) {
            this.ruleSet.providingConceptIds.computeIfAbsent(providedConcept.getProvidingConceptId(), id -> new LinkedHashSet()).add(providedConcept.getProvidedConceptId());
            this.ruleSet.providedConcepts.computeIfAbsent(providedConcept.getProvidedConceptId(), id -> new LinkedHashSet()).add(providedConcept);
        }
    }

    public RuleSet getRuleSet() throws RuleException {
        this.validate();
        return this.ruleSet;
    }

    private void validate() throws RuleException {
        Set<String> conceptIds = this.ruleSet.getConceptBucket().getIds();
        for (Map.Entry<String, Set<Concept.ProvidedConcept>> entry : this.ruleSet.getProvidedConcepts().entrySet()) {
            String providedConceptId = entry.getKey();
            if (conceptIds.contains(providedConceptId)) continue;
            for (Concept.ProvidedConcept providedConcept : entry.getValue()) {
                log.warn("Concept {} provides non-resolvable concept with id '{}'.", this.ruleSet.getConceptBucket().getById(providedConcept.getProvidingConceptId()), (Object)providedConceptId);
            }
        }
    }

    private static class DefaultRuleSet
    implements RuleSet {
        private final ConceptBucket conceptBucket = new ConceptBucket();
        private final Map<String, Set<String>> providingConceptIds = new HashMap<String, Set<String>>();
        private final ConstraintBucket constraintBucket = new ConstraintBucket();
        private final GroupsBucket groupsBucket = new GroupsBucket();
        private final Map<String, Set<Concept.ProvidedConcept>> providedConcepts = new HashMap<String, Set<Concept.ProvidedConcept>>();

        private DefaultRuleSet() {
        }

        @Override
        @Generated
        public ConceptBucket getConceptBucket() {
            return this.conceptBucket;
        }

        @Override
        @Generated
        public Map<String, Set<String>> getProvidingConceptIds() {
            return this.providingConceptIds;
        }

        @Override
        @Generated
        public ConstraintBucket getConstraintBucket() {
            return this.constraintBucket;
        }

        @Override
        @Generated
        public GroupsBucket getGroupsBucket() {
            return this.groupsBucket;
        }

        @Override
        @Generated
        public Map<String, Set<Concept.ProvidedConcept>> getProvidedConcepts() {
            return this.providedConcepts;
        }

        @Generated
        public String toString() {
            return "RuleSetBuilder.DefaultRuleSet(conceptBucket=" + String.valueOf(this.getConceptBucket()) + ", providingConceptIds=" + String.valueOf(this.getProvidingConceptIds()) + ", constraintBucket=" + String.valueOf(this.getConstraintBucket()) + ", groupsBucket=" + String.valueOf(this.getGroupsBucket()) + ", providedConcepts=" + String.valueOf(this.getProvidedConcepts()) + ")";
        }
    }
}

