/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.impl.writer;

import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.executor.CollectRulesVisitor;
import com.buschmais.jqassistant.core.rule.api.executor.RuleSetExecutor;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.api.writer.RuleSetWriter;
import com.buschmais.jqassistant.core.rule.impl.reader.CDataXMLStreamWriter;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jqassistant.schema.rule.v2.ActivationEnumType;
import org.jqassistant.schema.rule.v2.ConceptType;
import org.jqassistant.schema.rule.v2.ConstraintType;
import org.jqassistant.schema.rule.v2.GroupType;
import org.jqassistant.schema.rule.v2.IncludeConceptType;
import org.jqassistant.schema.rule.v2.IncludedReferenceType;
import org.jqassistant.schema.rule.v2.JqassistantRules;
import org.jqassistant.schema.rule.v2.ObjectFactory;
import org.jqassistant.schema.rule.v2.OptionalReferenceType;
import org.jqassistant.schema.rule.v2.ProvidesReferenceType;
import org.jqassistant.schema.rule.v2.SeverityEnumType;
import org.jqassistant.schema.rule.v2.SourceType;

public class XmlRuleSetWriter
implements RuleSetWriter {
    private final JAXBContext jaxbContext;
    private final Rule rule;

    public XmlRuleSetWriter(Rule rule) {
        this.rule = rule;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Cannot create JAXB context.", e);
        }
    }

    @Override
    public void write(RuleSet ruleSet, Writer writer) throws RuleException {
        CollectRulesVisitor visitor = new CollectRulesVisitor();
        RuleSelection ruleSelection = RuleSelection.builder().groupIds(ruleSet.getGroupsBucket().getIds()).constraintIds(ruleSet.getConstraintBucket().getIds()).conceptIds(ruleSet.getConceptBucket().getIds()).build();
        new RuleSetExecutor<Boolean>(visitor, this.rule).execute(ruleSet, ruleSelection);
        JqassistantRules rules = new JqassistantRules();
        this.writeGroups(visitor.getGroups(), rules);
        this.writeConcepts(visitor.getConcepts().keySet(), rules);
        this.writeConstraints(visitor.getConstraints().keySet(), rules);
        this.marshal(writer, rules);
    }

    private void marshal(Writer writer, JqassistantRules rules) throws RuleException {
        XMLStreamWriter streamWriter;
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        try {
            streamWriter = xof.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            throw new RuleException("Cannot create stream writer.", e);
        }
        IndentingXMLStreamWriter indentingStreamWriter = new IndentingXMLStreamWriter((XMLStreamWriter)new CDataXMLStreamWriter(streamWriter));
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)rules, (XMLStreamWriter)indentingStreamWriter);
        }
        catch (JAXBException e) {
            throw new RuleException("Cannot write rules to " + String.valueOf(writer), e);
        }
    }

    private void writeGroups(Collection<Group> groups, JqassistantRules rules) {
        for (Group group : groups) {
            HashMap providedConcepts = new HashMap();
            for (Map.Entry<String, Set<Concept.ProvidedConcept>> entry : group.getProvidedConcepts().entrySet()) {
                String providedConceptId = entry.getKey();
                for (Concept.ProvidedConcept providedConcept : entry.getValue()) {
                    providedConcepts.computeIfAbsent(providedConceptId, id -> new LinkedHashSet()).add(providedConcept);
                }
            }
            GroupType groupType = new GroupType();
            groupType.setId(group.getId());
            for (Map.Entry<String, Severity> groupEntry : group.getGroups().entrySet()) {
                IncludedReferenceType groupReferenceType = new IncludedReferenceType();
                groupReferenceType.setRefId(groupEntry.getKey());
                groupType.setSeverity(this.getSeverity(groupEntry.getValue()));
                groupType.getIncludeGroup().add(groupReferenceType);
            }
            for (Map.Entry<String, Severity> conceptEntry : group.getConcepts().entrySet()) {
                IncludeConceptType includeConceptType = new IncludeConceptType();
                includeConceptType.setRefId(conceptEntry.getKey());
                includeConceptType.setSeverity(this.getSeverity(conceptEntry.getValue()));
                this.addProvidesConcepts(providedConcepts.getOrDefault(conceptEntry.getKey(), Collections.emptySet()), includeConceptType);
                groupType.getIncludeConcept().add(includeConceptType);
            }
            for (Map.Entry<String, Severity> constraintEntry : group.getConstraints().entrySet()) {
                IncludedReferenceType constraintReferenceType = new IncludedReferenceType();
                constraintReferenceType.setRefId(constraintEntry.getKey());
                constraintReferenceType.setSeverity(this.getSeverity(constraintEntry.getValue()));
                groupType.getIncludeConstraint().add(constraintReferenceType);
            }
            rules.getConceptOrConstraintOrGroup().add(groupType);
        }
    }

    private void addProvidesConcepts(Set<Concept.ProvidedConcept> providesConceptIds, IncludeConceptType includeConceptType) {
        for (Concept.ProvidedConcept providedConcept : providesConceptIds) {
            ProvidesReferenceType providesReferenceType = this.getProvidesReferenceType(providedConcept);
            includeConceptType.getProvidesConcept().add(providesReferenceType);
        }
    }

    private void writeConcepts(Collection<Concept> concepts, JqassistantRules rules) {
        for (Concept concept : concepts) {
            ConceptType conceptType = new ConceptType();
            conceptType.setId(concept.getId());
            conceptType.setDescription(concept.getDescription());
            conceptType.setSeverity(this.getSeverity(concept.getSeverity()));
            conceptType.setSource(this.writeExecutable(concept));
            conceptType.getRequiresConcept().addAll(this.writeRequiredConcepts(concept));
            Set<Concept.ProvidedConcept> providedConcepts = concept.getProvidedConcepts();
            this.writeProvidedConcepts(providedConcepts, conceptType);
            rules.getConceptOrConstraintOrGroup().add(conceptType);
        }
    }

    private void writeConstraints(Collection<Constraint> constraints, JqassistantRules rules) {
        for (Constraint constraint : constraints) {
            ConstraintType constraintType = new ConstraintType();
            constraintType.setId(constraint.getId());
            constraintType.setDescription(constraint.getDescription());
            constraintType.setSeverity(this.getSeverity(constraint.getSeverity()));
            constraintType.setSource(this.writeExecutable(constraint));
            constraintType.getRequiresConcept().addAll(this.writeRequiredConcepts(constraint));
            rules.getConceptOrConstraintOrGroup().add(constraintType);
        }
    }

    private List<OptionalReferenceType> writeRequiredConcepts(ExecutableRule<?> rule) {
        return rule.getRequiresConcepts().entrySet().stream().map(entry -> {
            OptionalReferenceType conceptReferenceType = new OptionalReferenceType();
            conceptReferenceType.setRefId((String)entry.getKey());
            conceptReferenceType.setOptional((Boolean)entry.getValue());
            return conceptReferenceType;
        }).collect(Collectors.toList());
    }

    private void writeProvidedConcepts(Set<Concept.ProvidedConcept> providedConcepts, ConceptType conceptType) {
        for (Concept.ProvidedConcept providedConcept : providedConcepts) {
            ProvidesReferenceType providesReferenceType = this.getProvidesReferenceType(providedConcept);
            conceptType.getProvidesConcept().add(providesReferenceType);
        }
    }

    private ProvidesReferenceType getProvidesReferenceType(Concept.ProvidedConcept providedConcept) {
        ProvidesReferenceType providesReferenceType = new ProvidesReferenceType();
        providesReferenceType.setRefId(providedConcept.getProvidedConceptId());
        providesReferenceType.setActivation(ActivationEnumType.valueOf((String)providedConcept.getActivation().name()));
        return providesReferenceType;
    }

    private SourceType writeExecutable(ExecutableRule<?> executableRule) {
        Object executable = executableRule.getExecutable();
        if (executable != null) {
            SourceType sourceType = new SourceType();
            sourceType.setLanguage(executable.getLanguage());
            sourceType.setValue(executable.getSource().toString());
            return sourceType;
        }
        return null;
    }

    private SeverityEnumType getSeverity(Severity severity) {
        return severity != null ? SeverityEnumType.fromValue((String)severity.getValue()) : null;
    }
}

