/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.runtime.api.configuration;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.PropertiesConfigSource;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConfigurationBuilder {
    private final String name;
    private final int ordinal;
    private final Map<String, String> properties = new HashMap<String, String>();

    public ConfigurationBuilder(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public ConfigSource build() {
        return new PropertiesConfigSource(this.properties, this.name, this.ordinal);
    }

    public ConfigurationBuilder with(Class<?> mapping, String property, String value) {
        this.put(mapping, property, value);
        return this;
    }

    public ConfigurationBuilder with(Class<?> mapping, String property, URI value) {
        this.put(mapping, property, value);
        return this;
    }

    public ConfigurationBuilder with(Class<?> mapping, String property, Integer value) {
        this.put(mapping, property, value);
        return this;
    }

    public ConfigurationBuilder with(Class<?> mapping, String property, Boolean value) {
        this.put(mapping, property, value);
        return this;
    }

    public <E extends Enum<E>> ConfigurationBuilder with(Class<?> mapping, String property, E value) {
        this.put(mapping, property, value);
        return this;
    }

    public ConfigurationBuilder with(Class<?> mapping, String property, Map<String, ?> values) {
        if (values != null) {
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.addMapEntry(mapping, property, key, value);
            }
        }
        return this;
    }

    public ConfigurationBuilder with(Class<?> mapping, String property, Properties properties) {
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                this.addMapEntry(mapping, property, key, properties.getProperty(key));
            }
        }
        return this;
    }

    private void addMapEntry(Class<?> mapping, String property, String key, Object value) {
        StringBuilder keyBuilder = new StringBuilder(this.getKey(mapping, property)).append('.');
        if (key.contains(".")) {
            keyBuilder.append('\"').append(key).append('\"');
        } else {
            keyBuilder.append(key);
        }
        this.put(keyBuilder.toString(), value);
    }

    public <T> void with(Class<?> mapping, String indexedProperty, Iterable<T> values) {
        if (values != null) {
            int index = 0;
            for (T value : values) {
                StringBuilder key = new StringBuilder(this.getKey(mapping, indexedProperty)).append('[').append(index).append(']');
                this.put(key.toString(), value);
                ++index;
            }
        }
    }

    private String getKey(Class<?> mapping, String property) {
        ConfigMapping configMapping = mapping.getAnnotation(ConfigMapping.class);
        if (configMapping == null) {
            throw new IllegalArgumentException("Class " + mapping.getName() + " is not annotated with " + ConfigMapping.class.getName());
        }
        return configMapping.prefix() + '.' + property;
    }

    private <T> void put(Class<?> mapping, String property, T value) {
        this.put(this.getKey(mapping, property), value);
    }

    private <T> void put(String key, T value) {
        if (value != null) {
            this.properties.put(key, value.toString());
        }
    }
}

